#' @details
#' Refer to the vignette for an overview of the package,
#' quick start, and detailed usages.
#' @examples
#' browseVignettes("CircSeqAlignTk")
#'
'_PACKAGE'


#' Class to store reference information
#'
#' A class to store reference information for alignment.
#' The object belongs to this class
#' is generated by \code{\link{build_index}} function.
#'
#' @slot name Reference name.
#'     The sequence name written the header of FASTA format file.
#' @slot seq Reference sequence.
#' @slot length Length of the reference sequence.
#' @slot fasta A vector containing the paths to the two FASTA format files
#'     of the type 1 and type 2 reference sequences, respectively.
#'     See \code{\link{build_index}} for how FASTA format files are generated.
#' @slot index A vector containing the paths to the two reference indexes
#'     corresponding to the two FASTA format files
#'     stored in the \code{fasta} slot, respectively.
#' @slot cut_loc The position on the user-given sequence
#'     (i.e., the type 1 sequence)
#'     to cut for generating the type 2 reference sequence.
#' @seealso \code{\link{build_index}}
#' @export
setClass('CircSeqAlignTkRefIndex',
    slots = c(
        name = 'character',
        seq = 'character',
        length = 'numeric',
        fasta = 'vector',
        index = 'vector',
        cut_loc = 'numeric'
))


#' Class to store alignment results
#'
#' A class to store alignment results,
#' including the paths to FASTQ and BAM format files and the alignment summary.
#' The object belongs to this class
#' is generated by \code{\link{align_reads}} function.
#'
#' @slot input_fastq A path to the query FASTQ format file.
#' @slot fastq A vector containing the paths to the two FASTQ format files
#'     used for alignment to the type 1 and type 2 references,
#'     respectively. See \code{\link{align_reads}} for
#'     how the FASTQ format files are generated.
#' @slot bam A vector containing the paths to the two BAM format files
#'     corresponding to the alignment results of the two FASTQ files
#'     shown in the \code{fastq} slot, respectively.
#' @slot clean_bam A vector containing the paths to the two BAM format files
#'     after filtering by number of mismatch
#'     from BAM format files shown in \code{bam} slot.
#' @slot stats A data frame containing alignment summary,
#'     e.g., number of query reads, aligned reads, and unaligned reads.
#' @slot reference A \code{\link{CircSeqAlignTkRefIndex-class}}
#'     storing the information of reference for alignment.
#' @seealso \code{\link{CircSeqAlignTkRefIndex-class}}, \code{\link{align_reads}}
#' @export
setClass('CircSeqAlignTkAlign',
    slots = c(
        input_fastq = 'character',
        fastq = 'vector',
        bam = 'vector',
        clean_bam = 'vector',
        stats = 'data.frame',
        reference = 'CircSeqAlignTkRefIndex'
))


#' Class to save alignment coverage
#'
#' A class to store the alignment coverage
#' generated by \code{\link{calc_coverage}} function.
#'
#' @slot forward A matrix containing the alignment coverage of
#'     the forward strand reads.
#' @slot reverse A matrix containing the alignment coverage of
#'     the reverse strand reads.
#' @slot .figdata A string of adapter sequence.
#' @seealso \code{\link{calc_coverage}}
#' @export
setClass('CircSeqAlignTkCoverage',
         slots = c(
             forward = 'matrix',
             reverse = 'matrix',
             .figdata = 'data.frame'
         ))



#' Class to save information of synthetic reads
#'
#' A class to store parameters for generating synthetic sequence reads.
#' The object belongs to this class
#' is generated by \code{\link{generate_reads}} function.
#'
#' @slot seq A string of a genome sequence,
#'     which is used for sampling synthetic sequence reads.
#' @slot adapter A string of adapter sequence.
#' @slot read_info A data frame storing the summary information of read
#'     generation. It contains the start and end positions of sampling, strand,
#'     and nucleotide sequence of each synthetic read.
#' @slot peak A data frame storing the peaks information of alignment coverage.
#' @slot coverage A \code{\link{CircSeqAlignTkCoverage-class}}
#'     storing the information of alignment coverage.
#' @slot fastq A path to FASTQ format file saving the synthetic reads.
#' @seealso \code{\link{generate_reads}}, \code{\link{CircSeqAlignTkCoverage-class}}
#' @export
setClass('CircSeqAlignTkSim',
    slots = c(
        seq = 'character',
        adapter = 'character',
        read_info = 'data.frame',
        peak = 'data.frame',
        coverage = 'CircSeqAlignTkCoverage',
        fastq = 'character'
))

