% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_functions.R
\name{CompareWilcox}
\alias{CompareWilcox}
\title{CompareWilcox}
\usage{
CompareWilcox(
  dataMat = NULL,
  annot = NULL,
  ref_group = NULL,
  groups = NULL,
  featureTab = NULL,
  block = NULL,
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{dataMat}{A raw count matrix}

\item{annot}{A cell annotation data.frame}

\item{ref_group}{List with cells in reference group(s)}

\item{groups}{List with cells in group(s) to test}

\item{featureTab}{data.frame with feature annotation}

\item{block}{Use a blocking factor to conteract batch effect ?}

\item{BPPARAM}{BPPARAM object for multiprocessing. See
\link[BiocParallel]{bpparam} for more informations. Will take the default
BPPARAM set in your R session.}
}
\value{
A dataframe containing the foldchange and p.value of each feature
}
\description{
CompareWilcox
}
\examples{
data("scExp")
scExp_cf = correlation_and_hierarchical_clust_scExp(scExp)
scExp_cf = choose_cluster_scExp(scExp_cf,nclust=2,consensus=FALSE)
featureTab = as.data.frame(SummarizedExperiment::rowRanges(scExp_cf))
rownames(featureTab) = featureTab$ID
ref_group = list("C1"=scExp_cf$cell_id[which(scExp_cf$cell_cluster=="C1")])
groups = list("C2"=scExp_cf$cell_id[which(scExp_cf$cell_cluster=="C2")])
myres = CompareWilcox(as.matrix(SingleCellExperiment::normcounts(scExp_cf)),
annot=as.data.frame(SingleCellExperiment::colData(scExp_cf)),
   ref_group=ref_group,groups=groups, featureTab=featureTab)

}
\author{
Eric Letouze & Celine Vallot & Pacome Prompsy
}
