% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findOverlapsOfPeaks.R
\name{findOverlapsOfPeaks}
\alias{findOverlapsOfPeaks}
\alias{overlappingPeaks}
\alias{overlappingPeaks-class}
\title{Find the overlapped peaks among two or more set of peaks.}
\usage{
findOverlapsOfPeaks(
  ...,
  maxgap = -1L,
  minoverlap = 0L,
  ignore.strand = TRUE,
  connectedPeaks = c("keepAll", "min", "merge")
)
}
\arguments{
\item{\dots}{Objects of \link[GenomicRanges:GRanges-class]{GRanges}: See
example below.}

\item{maxgap, minoverlap}{Used in the internal call to \code{findOverlaps()}
to detect overlaps. See
\code{?\link[IRanges:findOverlaps-methods]{findOverlaps}} in the
\pkg{IRanges} package for a description of these arguments. 
If 0 < minoverlap < 1, the function will find overlaps by percentage
covered of interval and the filter condition will be set to max covered 
percentage of overlapping peaks.}

\item{ignore.strand}{When set to TRUE, the strand information is ignored in
the overlap calculations.}

\item{connectedPeaks}{If multiple peaks are involved in any group of 
connected/overlapping peaks in any input peak list, set it to "merge" will
add 1 to the overlapping counts, while set it to "min" will add the minimal 
involved peaks in each group of connected/overlapped peaks to the 
overlapping counts. Set it to "keepAll" will add the number of involved 
peaks for each peak list to the corresponding overlapping counts. 
In addition, it will output counts as if connectedPeaks were set to "min".
For examples (https://support.bioconductor.org/p/133486/#133603), 
if 5 peaks in group1 overlap with 2 peaks in group 2, setting connectedPeaks
 to "merge" will add 1 to the overlapping counts; setting it to "keepAll" 
 will add 5 peaks to count.group1, 2 to count.group2, and 2 to counts; 
 setting it to “min” will add 2 to the overlapping counts.}
}
\value{
return value is An object of overlappingPeaks.  \item{venn_cnt}{an
object of VennCounts} \item{peaklist}{a list consists of all overlapping
peaks or unique peaks} \item{uniquePeaks}{an object of
\link[GenomicRanges:GRanges-class]{GRanges} consists of all unique peaks}
\item{mergedPeaks}{an object of \link[GenomicRanges:GRanges-class]{GRanges}
consists of all merged overlapping peaks} \item{peaksInMergedPeaks}{an
object of \link[GenomicRanges:GRanges-class]{GRanges} consists of all peaks
in each samples involved in the overlapping peaks} \item{overlappingPeaks}{a
list of data frame consists of the annotation of all the overlapped peaks}
\item{all.peaks}{a list of GRanges object which contain the input peaks with
formated rownames.}
}
\description{
Find the overlapping peaks for two or more (less than five) set of peak
ranges.
}
\details{
Efficiently perform overlap queries with an interval tree implemented with
GRanges.
}
\examples{

peaks1 <- GRanges(seqnames=c(6,6,6,6,5),
                 IRanges(start=c(1543200,1557200,1563000,1569800,167889600),
                         end=c(1555199,1560599,1565199,1573799,167893599),
                         names=c("p1","p2","p3","p4","p5")),
                 strand="+")
peaks2 <- GRanges(seqnames=c(6,6,6,6,5),
                  IRanges(start=c(1549800,1554400,1565000,1569400,167888600),
                          end=c(1550599,1560799,1565399,1571199,167888999),
                          names=c("f1","f2","f3","f4","f5")),
                  strand="+")
t1 <- findOverlapsOfPeaks(peaks1, peaks2, maxgap=1000)
makeVennDiagram(t1)
t1$venn_cnt
t1$peaklist
t2 <- findOverlapsOfPeaks(peaks1, peaks2, minoverlap = .5)
makeVennDiagram(t2)

t3 <- findOverlapsOfPeaks(peaks1, peaks2, minoverlap = .90)
makeVennDiagram(t3)

}
\references{
1.Interval tree algorithm from: Cormen, Thomas H.; Leiserson,
Charles E.; Rivest, Ronald L.; Stein, Clifford. Introduction to Algorithms,
second edition, MIT Press and McGraw-Hill. ISBN 0-262-53196-8

2.Zhu L.J. et al. (2010) ChIPpeakAnno: a Bioconductor package to annotate
ChIP-seq and ChIP-chip data. BMC Bioinformatics 2010,
11:237doi:10.1186/1471-2105-11-237

3. Zhu L (2013). "Integrative analysis of ChIP-chip and ChIP-seq dataset."
In Lee T and Luk ACS (eds.), Tilling Arrays, volume 1067, chapter 4, pp.
-19. Humana Press. http://dx.doi.org/10.1007/978-1-62703-607-8_8,
http://link.springer.com/protocol/10.1007\%2F978-1-62703-607-8_8
}
\seealso{
\link{annotatePeakInBatch}, \link{makeVennDiagram},
\link{getVennCounts}, \link{findOverlappingPeaks}
}
\author{
Jianhong Ou
}
\keyword{misc}
