% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estLibSize.R
\name{estLibSize}
\alias{estLibSize}
\title{estimate the library size}
\usage{
estLibSize(bamfiles, index = bamfiles, ...)
}
\arguments{
\item{bamfiles}{The file names of the 'BAM' ('SAM' for asBam) files to be
processed.}

\item{index}{The names of the index file of the 'BAM' file being processed;
this is given without the '.bai' extension.}

\item{\dots}{Not used.}
}
\value{
numberic vector
}
\description{
estimate the library size of bam files
}
\examples{

    if(interactive() || Sys.getenv("USER")=="jou"){
        path <- system.file("extdata", "reads", package="MMDiffBamSubset")
        if(file.exists(path)){
            WT.AB2 <- file.path(path, "WT_2.bam")
            Null.AB2 <- file.path(path, "Null_2.bam")
            Resc.AB2 <- file.path(path, "Resc_2.bam")
            estLibSize(c(WT.AB2, Null.AB2, Resc.AB2))
        }
    }

}
\author{
Jianhong Ou
}
\keyword{misc}
