% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binOverGene.R
\name{binOverGene}
\alias{binOverGene}
\title{coverage of gene body}
\usage{
binOverGene(
  cvglists,
  TxDb,
  upstream.cutoff = 0L,
  downstream.cutoff = upstream.cutoff,
  nbinsGene = 100L,
  nbinsUpstream = 20L,
  nbinsDownstream = nbinsUpstream,
  includeIntron = FALSE,
  minGeneLen = nbinsGene,
  maxGeneLen = Inf
)
}
\arguments{
\item{cvglists}{A list of \link[IRanges:AtomicList-class]{SimpleRleList} or
\link[IRanges:AtomicList-class]{RleList}. It represents the coverage for
samples.}

\item{TxDb}{An object of \code{\link[GenomicFeatures:TxDb-class]{TxDb}}.  It
is used for extracting the annotations.}

\item{upstream.cutoff, downstream.cutoff}{cutoff length for upstream or
downstream of transcript.}

\item{nbinsGene, nbinsUpstream, nbinsDownstream}{The number of bins for gene,
upstream and downstream.}

\item{includeIntron}{A logical value which indicates including intron or
not.}

\item{minGeneLen, maxGeneLen}{minimal or maximal length of gene.}
}
\description{
calculate the coverage of gene body per gene per bin.
}
\examples{

if(Sys.getenv("USER")=="jou"){
path <- system.file("extdata", package="ChIPpeakAnno")
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
library(rtracklayer)
files <- dir(path, "bigWig")
if(.Platform$OS.type != "windows"){
cvglists <- lapply(file.path(path, files), import,
                   format="BigWig", as="RleList")
names(cvglists) <- sub(".bigWig", "", files)
d <- binOverGene(cvglists, TxDb.Hsapiens.UCSC.hg19.knownGene)
plotBinOverRegions(d)
}
}

}
\seealso{
\link{binOverRegions}, \link{plotBinOverRegions}
}
\author{
Jianhong Ou
}
