% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea.R
\name{RunCellGSEA}
\alias{RunCellGSEA}
\alias{RunCellGSEA.Seurat}
\alias{RunCellGSEA.SingleCellExperiment}
\title{Run Gene Set Enrichment Analysis on cells}
\usage{
RunCellGSEA(
  X,
  pathways,
  reduction,
  dims,
  features,
  cells,
  nperm,
  minSize,
  maxSize,
  gseaParam,
  n.core
)

\method{RunCellGSEA}{Seurat}(
  X,
  pathways,
  reduction = "mca",
  dims = seq(50),
  features = NULL,
  cells = NULL,
  nperm = 1000,
  minSize = 10,
  maxSize = 500,
  gseaParam = 0,
  n.core = 1
)

\method{RunCellGSEA}{SingleCellExperiment}(
  X,
  pathways,
  reduction = "mca",
  dims = seq(50),
  features = NULL,
  cells = NULL,
  nperm = 1000,
  minSize = 10,
  maxSize = 500,
  gseaParam = 0,
  n.core = 1
)
}
\arguments{
\item{X}{Seurat or SingleCellExperiment object}

\item{pathways}{List of gene sets to check}

\item{reduction}{Which dimensionality reduction to use, must be based on MCA.}

\item{dims}{A vector of integers indicating which dimensions to use with reduction embeddings and loadings for distance calculation.}

\item{features}{Character vector of feature names to subset feature coordinates. If not specified will take all features available from specified reduction Loadings.}

\item{cells}{Character vector of cell names to subset cell coordinates. If not specified will take all features available from specified reduction Embeddings}

\item{nperm}{Number of permutations to do. Minimial possible nominal p-value is about 1/nperm}

\item{minSize}{Minimal size of a gene set to test. All pathways below the threshold are excluded.}

\item{maxSize}{Maximal size of a gene set to test. All pathways above the threshold are excluded.}

\item{gseaParam}{GSEA parameter value, all gene-level statis are raised to the power of 'gseaParam' before calculation of GSEA enrichment scores}

\item{n.core}{A single integer to specify the number of core for parallelisation.}
}
\value{
A data.table with geneset enrichment analysis statistics.
}
\description{
Calculate cells gene specificty ranking and then perform geneset enrichment analysis (fgsea) on it.
However, due to the very long running time of gene set enrichment analysis, we recommend the usage of RunCellHGT.
}
\examples{
seuratPbmc <- RunMCA(seuratPbmc, nmcs = 5)
GSEAResults <- RunCellGSEA(seuratPbmc, Hallmark, dims = 1:5)
}
