% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.R
\name{GetGroupGeneRanking}
\alias{GetGroupGeneRanking}
\alias{GetGroupGeneRanking.Seurat}
\alias{GetGroupGeneRanking.SingleCellExperiment}
\title{Gene Specificity Ranking Calculation}
\usage{
GetGroupGeneRanking(X, group.by, reduction, dims, features)

\method{GetGroupGeneRanking}{Seurat}(
  X,
  group.by = NULL,
  reduction = "mca",
  dims = seq(50),
  features = NULL
)

\method{GetGroupGeneRanking}{SingleCellExperiment}(
  X,
  group.by,
  reduction = "MCA",
  dims = seq(50),
  features = NULL
)
}
\arguments{
\item{X}{Seurat or SingleCellExperiment object, alternatively a matrix.}

\item{group.by}{column name of meta.data (Seurat) or ColData (SingleCellExperiment)}

\item{reduction}{Which dimensionality reduction to use, must be based on MCA.}

\item{dims}{A vector of integers indicating which dimensions to use with reduction embeddings and loadings for distance calculation.}

\item{features}{A character vector of features name to subset feature coordinates for distance calculation.}
}
\value{
List of genes ranking for each groups
}
\description{
Gene Specificity Ranking Calculation
}
\examples{
seuratPbmc <- RunMCA(seuratPbmc, nmcs = 5)
GroupGeneRanking <- GetGroupGeneRanking(seuratPbmc, group.by = "seurat_clusters", dims = 1:5)
}
