% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell.R
\name{GetCellGeneRanking}
\alias{GetCellGeneRanking}
\alias{GetCellGeneRanking.Seurat}
\alias{GetCellGeneRanking.SingleCellExperiment}
\title{Ranking Extraction}
\usage{
GetCellGeneRanking(X, reduction, dims, features, cells)

\method{GetCellGeneRanking}{Seurat}(
  X,
  reduction = "mca",
  dims = seq(50),
  features = NULL,
  cells = NULL
)

\method{GetCellGeneRanking}{SingleCellExperiment}(
  X,
  reduction = "MCA",
  dims = seq(50),
  features = NULL,
  cells = NULL
)
}
\arguments{
\item{X}{Seurat or SingleCellExperiment Object}

\item{reduction}{Which dimensionality reduction to use, must be based on MCA.}

\item{dims}{A vector of integers indicating which dimensions to use with reduction embedding and loading for distance calculation.}

\item{features}{Character vector of feature names to subset feature coordinates. If not specified will take all features available from specified reduction Loading}

\item{cells}{Character vector of cell names to subset cell coordinates. If not specified will take all features available from specified reduction Embedding.}
}
\value{
A cell named list of gene rankings ordererd by distances from shortest (most specific) to farthest (less specific)
}
\description{
Intermediate function for ranking extraction from Cell Gene Distance Matrix. 
Genes are ordered from the most specific to the least specific to the cell according to their euclidean distances.
Value indicates the euclidean distances between the cell and the genes in the MCA coordinates.
}
\examples{
seuratPbmc <- RunMCA(seuratPbmc, nmcs = 5)
ranking <- GetCellGeneRanking(seuratPbmc, reduction = "mca", dims = 1:5)
}
