% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-toy.R
\docType{data}
\name{ref_matrix_toy}
\alias{ref_matrix_toy}
\alias{qry_matrix_toy}
\alias{ref_celltype_toy}
\title{Tiny toy matrices and labels for runnable examples}
\format{
\itemize{
\item \code{ref_matrix_toy}: numeric matrix (50 genes x 12 cells), dimnames set.
\item \code{qry_matrix_toy}: numeric matrix (50 genes x 8 cells), dimnames set.
\item \code{ref_celltype_toy}: character vector of length 12, names match \code{colnames(ref_matrix_toy)}.
}

An object of class \code{matrix} (inherits from \code{array}) with 50 rows and 8 columns.

An object of class \code{character} of length 12.
}
\usage{
ref_matrix_toy

qry_matrix_toy

ref_celltype_toy
}
\description{
Tiny toy matrices and labels for runnable examples
}
\details{
These are minimal, non-biological toy data with shared gene IDs across
reference and query for fast runnable examples and tests.
}
\examples{
data(ref_matrix_toy, package = "CellMentor")
data(qry_matrix_toy, package = "CellMentor")
data(ref_celltype_toy, package = "CellMentor")
dim(ref_matrix_toy); dim(qry_matrix_toy)
head(ref_celltype_toy)
}
\keyword{datasets}
