% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_step.R
\name{split_step}
\alias{split_step}
\title{Split combined pipeline step}
\usage{
split_step(x, step, into)
}
\arguments{
\item{x}{a results data.frame from `apply_methods()`.}

\item{step}{the name of the column to split.}

\item{into}{the name of the columns to split into.}
}
\value{
a results data.frame where the `step` column has been split into
the `into` columns with duplicated values.
}
\description{
Some methods perform multiple steps of a pipeline. This function assists with
splitting the combined pipeline step into multiple steps with duplicated
method names.
}
\examples{
datasets <- list(
    set1 = rnorm(500, mean = 2, sd = 1),
    set2 = rnorm(500, mean = 1, sd = 2)
)

# list of functions
add_noise <- list(
    none = identity,
    add_bias = function(x) { x + 1 }
)

res <- apply_methods(datasets, add_noise)

res \%>\%
    split_step("add_noise", c("split1", "split2"))
}
