% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-plot_barcode.R
\name{bc_plot_mutual}
\alias{bc_plot_mutual}
\alias{bc_plot_mutual,BarcodeObj-method}
\title{Barcode read count 2D scatter plot of sample combination}
\usage{
bc_plot_mutual(
  barcodeObj,
  count_marks = NULL,
  highlight = NULL,
  log_coord = TRUE,
  alpha = 0.7
)

\S4method{bc_plot_mutual}{BarcodeObj}(
  barcodeObj,
  count_marks = NULL,
  highlight = NULL,
  log_coord = TRUE,
  alpha = 0.7
)
}
\arguments{
\item{barcodeObj}{A \code{BarcodeObj} object, which has a \code{cleanBc} slot}

\item{count_marks}{A numeric or numeric vector, specifying the read count
cutoff in the scatter plot for each sample.}

\item{highlight}{A character vector, specifying the barcodes to be
highlighted.}

\item{log_coord}{A logical value, if TRUE (default), the \code{x} and
\code{y} coordinates of the scatter plot will be logarized by \code{log10.}}

\item{alpha}{A numeric between 0 and 1, specifies the transparency of the
dots in the scatter plot.}
}
\value{
A scatter plot matrix.
}
\description{
Draw barcode count scatter plot for all pairwise combinations of samples
within a \code{BarcodeObj} object. It uses \code{cleanBc} slot in the
\code{BarcodeObj} object is used to draw the figure. If the \code{BarcodeObj}
object does not have a cleanBc slot, you have to run the \code{bc_cure*}
functions in ahead, such as \code{\link[CellBarcode]{bc_cure_depth}},
\code{\link[CellBarcode]{bc_cure_umi}}.
}
\examples{

data(bc_obj)

bc_plot_mutual(barcodeObj=bc_obj, count_marks=c(30, 20))
###
}
