% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{tolerance}
\alias{tolerance}
\title{Tolerance level between 3 pairwise correlations implemented in C/C++}
\usage{
tolerance(a, b, c, tolType)
}
\arguments{
\item{a}{Correlation value between the genes A and B.}

\item{b}{Correlation value between the genes B and C.}

\item{c}{Correlation value between the genes A and C.}

\item{tolType}{Calculation type for tolerance (1 for mean, 2 for min and 3 for max).}
}
\value{
Returns the value of tolerance.
}
\description{
Calculates the local tolerance for every trio of genes.
}
\examples{
tolerance(0.5, -0.65, 0.23, tolType = 1)
tolerance(0.5, -0.65, 0.23, tolType = 2)
tolerance(0.5, -0.65, 0.23, tolType = 3)

}
\seealso{
See vignette for more details about the pairwise correlations.
}
