% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pcitC}
\alias{pcitC}
\title{A helper to calculate PCIT implemented in C/C++}
\usage{
pcitC(cor, tolType)
}
\arguments{
\item{cor}{A correlation matrix.}

\item{tolType}{Type of tolerance (default: 'mean') given the 3 pairwise correlations 
(see \code{\link{tolerance}}.}
}
\value{
Correlation matrix resulted from PCIT algorithm.
}
\description{
Calculates the correlation matrix using PCIT algorithm
}
\examples{
library(Matrix)

# loading a simulated normalized data
data('simNorm')

# calculating the correlation matrix
suppressWarnings(gene_corr <- cor(t(simNorm[1:30, ])))
gene_corr[is.na(gene_corr)] <- 0

# getting the PCIT correlation results for first 30 genes
results <- pcitC(cor = Matrix(gene_corr, sparse = TRUE), 
                tolType = 1)

}
\seealso{
(see \code{\link{PCIT}})
}
