% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetNodeName.r
\name{GetNodeName}
\alias{GetNodeName}
\title{get node name}
\usage{
GetNodeName(network, nodeID, signed = FALSE)
}
\arguments{
\item{network}{Built from igraph}

\item{nodeID}{a node ID or a matrix containing node IDs in its first column}

\item{signed}{whether or not the node name should be signed. Setting this value to TRUE gives a signed name indicating whether the gene is up or down regulated in the network}
}
\value{
a node name or a vector of node names depending if the input is an matrix.
}
\description{
Returns the node name from one or more node IDs, or substitute node names for node IDs,
given in first column of a matrix typically of  predictions or experimental data
}
\examples{
network <- system.file(package='CausalR', 'extdata', 'testNetwork.sif')
ccg = CreateCCG(network)
nodeID <- 10
GetNodeName(ccg, nodeID)
}
\concept{
CausalR
}

