% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMaximumDValueFromTwoByTwoContingencyTable.r
\name{GetMaximumDValueFromTwoByTwoContingencyTable}
\alias{GetMaximumDValueFromTwoByTwoContingencyTable}
\title{get maximum D value from two-by-two contingency table}
\usage{
GetMaximumDValueFromTwoByTwoContingencyTable(twoByTwoContingencyTable,
  predictionListStats, experimentalDataStats,
  logOfFactorialOfPredictionListStats, returnlog = FALSE)
}
\arguments{
\item{twoByTwoContingencyTable}{approximate values of n++, n+-, n-+ and n--, these values arecalculated to optimise the D-value}

\item{predictionListStats}{a vector containing the values q+, q- and q0 the number of positive/negative/non-significant (or contradictory) predictions)}

\item{experimentalDataStats}{a vector containing the values n+, n- and n0 (the number of positive/negative/non-significant (or contradictory) transcripts in the results)}

\item{logOfFactorialOfPredictionListStats}{a vector containing the log of the factorial value for each entry in predictionListStats}

\item{returnlog}{whether or not he value should be returned as a log (TRUE) or not (FALSE)}
}
\value{
the maximal D-value
}
\description{
Computes the maximum D value (or weight) given approximate values of n++, n+-, n-+ and n--.
These values are approximate and in general are non-integer values; they are found by using an 
approximation detailed in the paper Assessing statistical significance in causal graphs on page 6 i.e. n_ab is approximately
equal to q_a*n_b/t where a and b are either +, - or 0. The value is an approximation since the direction in which the 
number should be rounded is not clear and hence this function runs through all possible combinations of rounding before
concluding the maximum D-value.
}
\references{
L Chindelevitch et al.
Assessing statistical significance in causal graphs.
BMC Bioinformatics, 13(35), 2012.
}

