% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGeometricClustering.R
\name{medianComplementPValue}
\alias{medianComplementPValue}
\title{This takes a set S of n points in dimension d and a subset
A and computes a p-value for the co-localization of the subset
by comparing the median complement distance for the given set
to values of the median complement distance computed for random
subsets of the same size.}
\usage{
medianComplementPValue(S, idx, numTrials = 1000, returnTrials = FALSE)
}
\arguments{
\item{S}{\itemize{
\item an n x d matrix representing a set of n points
in dimension d
}}

\item{idx}{\itemize{
\item a logical of length n representing a subset of
S.  This should not be the empty set or all of S.
}}

\item{numTrials}{\itemize{
\item the number of random trials to perform,
defaults to 1000
}}

\item{returnTrials}{\itemize{
\item whether to report the real and random median
complement distances.
}}
}
\value{
By default this reports a p-value.  If returnTrials is set,
this returns a list giving the p-value, the actual complement distance
and the random complement distances.
}
\description{
This takes a set S of n points in dimension d and a subset
A and computes a p-value for the co-localization of the subset
by comparing the median complement distance for the given set
to values of the median complement distance computed for random
subsets of the same size.
}
\examples{
library(Seurat)
getExample = make.getExample()
STranspose = getExample('STranspose',toy=TRUE)
hallmark = getExample('hallmark')
S = data.matrix(FetchData(STranspose,c('umap_1','umap_2')))
idx = colnames(STranspose) \%in\% hallmark[["HALLMARK_TNFA_SIGNALING_VIA_NFKB"]]
mcpv = medianComplementPValue(S,idx,numTrials=100)
}
