% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGeometricClustering.R
\name{medianComplementDistance}
\alias{medianComplementDistance}
\title{This takes a set S of n points in dimension d given
by an n x d matrix and a subset A given by a logical
and returns the median distance from the complement to
the given subset.}
\usage{
medianComplementDistance(S, idx)
}
\arguments{
\item{S}{\itemize{
\item an n x d matrix representing a set of n points
in dimension d
}}

\item{idx}{\itemize{
\item a logical of length n representing a subset of
S.  This should not be the empty set or all of S.
}}
}
\value{
This returns the median distance from the complement
to the subset
}
\description{
This takes a set S of n points in dimension d given
by an n x d matrix and a subset A given by a logical
and returns the median distance from the complement to
the given subset.
}
\examples{
S = matrix(seq_len(12),ncol=2)
idx = c(rep(FALSE,3),rep(TRUE,3))
compDist = medianComplementDistance(S,idx)
}
