% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleLigandReceptorAnalysis.R
\name{getInteractionsOnEdges}
\alias{getInteractionsOnEdges}
\title{This function takes a binarised expression matrix, a set of ligand receptor
pairs and a set of edges denoting neighbouring cells and
annotates these with the ligand receptor interactions taking
place on those edges in each direction.}
\usage{
getInteractionsOnEdges(M, pairDF, spatialGraph)
}
\arguments{
\item{M}{\itemize{
\item a binarised expression matrix where rows are genes and columns
are cells.
}}

\item{pairDF}{\itemize{
\item a data frame giving the ligand-receptor pairs
}}

\item{spatialGraph}{\itemize{
\item a data frame of neighbouring
cell pairs.  Note that each row is a directed edge (A,B) so
that this data frame should have both the edge (A,B) and the
edge (B,A)
}}
}
\value{
This returns a data frame whose first two columns give
the neighbouring cells.  Each of the remaining columns is a logical
corresponding to a ligand-receptor pair telling whether the ligand
is expressed in the first cell and the receptor is expressed in the
second cell.
}
\description{
This function takes a binarised expression matrix, a set of ligand receptor
pairs and a set of edges denoting neighbouring cells and
annotates these with the ligand receptor interactions taking
place on those edges in each direction.
}
