% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleEdgeQualityControl.R
\name{edgeLengthsAndCellTypePairs}
\alias{edgeLengthsAndCellTypePairs}
\title{This function annotates edges with their distance and
the types of cells they connect}
\usage{
edgeLengthsAndCellTypePairs(edges, clusters, centroids)
}
\arguments{
\item{edges}{\itemize{
\item A data frame with columns nodeA and nodeB giving the
cells of each edge
}}

\item{clusters}{\itemize{
\item the clusters of each cell
}}

\item{centroids}{\itemize{
\item the centroids of each cell
}}
}
\value{
a data frame giving the edges (as nodeA and nodeB), their
lengths and the cell type pair.
}
\description{
This function annotates edges with their distance and
the types of cells they connect
}
\examples{
getExample = make.getExample()
centroids = getExample('centroids')
clusters = getExample('clusters')
delaunayNeighbours = getExample('delaunayNeighbours')
annEdges = edgeLengthsAndCellTypePairs(delaunayNeighbours,clusters,centroids)
}
