% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleNeighbourhoods.R
\name{computeNeighboursEuclidean}
\alias{computeNeighboursEuclidean}
\title{This function computes a spatial graph where
neighbors are identified based on euclidean distance and a
user defined threshold.}
\usage{
computeNeighboursEuclidean(centroids, threshold)
}
\arguments{
\item{centroids}{\itemize{
\item a dataframe containing centroids
where rownames are cellnames and columns contain x
and y coordinates respectively.
}}

\item{threshold}{\itemize{
\item a distance cut off to compute neighbours.
}}
}
\value{
a graph in neighbour format, i.e., a data frame with
columns nodeA and nodeB.
}
\description{
This function computes a spatial graph where
neighbors are identified based on euclidean distance and a
user defined threshold.
}
\examples{
centroids = make.getExample()('centroids')
euclideanNeighbours = computeNeighboursEuclidean(centroids,20)
}
