#' YAP/TAZ Activity in TCGA BRCA dataset
#'
#' A vector of continuous scores represents oncogenic YAP/TAZ activity
#' in human breast carcinomas
#'
#' @docType data
#'
#' @usage data(TAZYAP_BRCA_ACTIVITY)
#'
#' @format consists of a vector of continuous scores of YAP/TAZ activity
#' across 951 profiles. The mutation and copy number associated with this sample
#' cohorts can be found in \code{BRCA_GISTIC_MUT_SIG} dataset.
#' 
#' @return a vector of continuous scores
#' 
#' @references Kartha VK, Kern JG, Sebastiani P, Zhang L,
#' Varelas X, Monti S (2019) CaDrA: A computational framework for performing
#' candidate driver analyses using binary genomic features.
#' (\href{https://www.frontiersin.org/articles/10.3389/fgene.2019.00121/full}{Frontiers in Genetics})
#'
"TAZYAP_BRCA_ACTIVITY"
