% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCLE_expression.R
\name{CCLE_expression}
\alias{CCLE_expression}
\title{Gene expression in CCLE Tumors}
\usage{
CCLE_expression(
  genes = NULL,
  type = NULL,
  units = c("TPM", "log_TPM"),
  include_CTP = FALSE,
  values_only = FALSE
)
}
\arguments{
\item{genes}{\code{character} naming the selected genes. The default
value, \code{NULL}, takes all CT (specific) genes.}

\item{type}{\code{character()} describing the tumor cell line(s) type to
be plotted. Allowed cell lines are "Ovarian", "Leukemia",
"Colorectal", "Skin", "Lung", "Bladder", "Kidney", "Breast",
"Pancreatic", "Myeloma", "Brain", "Sarcoma", "Lymphoma",
"Bone", "Neuroblastoma", "Gastric", "Uterine", "Head_and_Neck",
"Bile_Duct" and "Esophageal".}

\item{units}{\code{character(1)} with expression values unit. Can be
"TPM" (default) or "log_TPM" (log(TPM + 1))}

\item{include_CTP}{\code{logical(1)} If \code{TRUE}, CTP genes are included.
(\code{FALSE} by default).}

\item{values_only}{\code{logical(1)}. If \code{TRUE}, values are returned instead
of the heatmap (\code{FALSE} by default).}
}
\value{
A heatmap of selected genes in CCLE cell lines from
specified type.  If \code{values_only} is \code{TRUE}, expression values are
returned instead.
}
\description{
Plots an expression heatmap of genes in CCLE tumor cell lines.
}
\examples{
\dontrun{
CCLE_expression(
    genes = c("MAGEA1", "MAGEA3", "MAGEA4", "MAGEA6", "MAGEA10"),
    type = c("Skin", "Lung"), units = "log_TPM")
}
}
