% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaf_plot.R
\name{leaf_plot}
\alias{leaf_plot}
\title{Function to create a leaf plot}
\usage{
leaf_plot(
  dta,
  label = "name",
  valueLeft = "var1",
  valueRight = "var2",
  titleLeft = NULL,
  titleRight = NULL,
  colorLeft = "#FF7F50",
  colorRight = "#20B2AA"
)
}
\arguments{
\item{dta}{\code{data.frame} with, at last, three columns corresponding
to the axis labels, the left values and the right values.}

\item{label}{(default \code{"name"}) Name of the column in \code{dta}
with the labels.}

\item{valueLeft}{(default \code{"var1"}) Name of the column with the
values for the left plot.}

\item{valueRight}{(default \code{"var2"}) Name of the column with the
values for the right plot.}

\item{titleLeft}{(default \code{NULL}) Character used as a title for the
left plot.}

\item{titleRight}{(default \code{NULL}) Character used as a title for the
right plot.}

\item{colorLeft}{(default \code{"#FF7F50"}) Color for left plot bars.}

\item{colorRight}{(default \code{"#20B2AA"}) Color for right plot bars.}
}
\value{
A ggplo2 object.
}
\description{
This functions taked a \code{data.frame} and returns a \code{gtable}
with three plots. The left-leafes, the axis names and the right-leafes.
}
\examples{
data <- data.frame(
   labels = LETTERS[1:15],
   right = runif(n = 15) * 11,
   left = runif(n = 15) * 9
)
leaf_plot( data, "labels", "left", "right", "runif09", "runif11")
}
