% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/UTCheckers.R
\docType{class}
\name{UniformTranscriptCheckers}
\alias{UniformTranscriptCheckers}
\alias{BaseUniformityCheck-class}
\alias{GDICheck-class}
\alias{SimpleGDIUniformityCheck-class}
\alias{AdvancedGDIUniformityCheck-class}
\alias{checkObjIsUniform,SimpleGDIUniformityCheck-method}
\alias{checkObjIsUniform}
\alias{checkObjIsUniform,AdvancedGDIUniformityCheck-method}
\alias{checkersToDF}
\alias{dfToCheckers}
\alias{getCheckerThreshold,SimpleGDIUniformityCheck-method}
\alias{getCheckerThreshold}
\alias{getCheckerThreshold,AdvancedGDIUniformityCheck-method}
\alias{calculateThresholdShiftToUniformity,SimpleGDIUniformityCheck-method}
\alias{calculateThresholdShiftToUniformity}
\alias{calculateThresholdShiftToUniformity,AdvancedGDIUniformityCheck-method}
\alias{shiftCheckerThresholds,SimpleGDIUniformityCheck,numeric-method}
\alias{shiftCheckerThresholds}
\alias{shiftCheckerThresholds,AdvancedGDIUniformityCheck,numeric-method}
\title{Definition of the \strong{Transcript Uniformity Checker} classes}
\usage{
\S4method{checkObjIsUniform}{SimpleGDIUniformityCheck}(currentC, previousC = NULL, objCOTAN = NULL)

\S4method{checkObjIsUniform}{AdvancedGDIUniformityCheck}(currentC, previousC = NULL, objCOTAN = NULL)

checkersToDF(checkers)

dfToCheckers(df, checkerClass = "")

\S4method{getCheckerThreshold}{SimpleGDIUniformityCheck}(checker)

\S4method{getCheckerThreshold}{AdvancedGDIUniformityCheck}(checker)

\S4method{calculateThresholdShiftToUniformity}{SimpleGDIUniformityCheck}(checker)

\S4method{calculateThresholdShiftToUniformity}{AdvancedGDIUniformityCheck}(checker)

\S4method{shiftCheckerThresholds}{SimpleGDIUniformityCheck,numeric}(checker, shift)

\S4method{shiftCheckerThresholds}{AdvancedGDIUniformityCheck,numeric}(checker, shift)
}
\arguments{
\item{currentC}{the object that defines the method and the threshold to
discriminate whether a \emph{cluster} is \emph{uniform transcript}.}

\item{previousC}{the optional result object of an already done check}

\item{objCOTAN}{an optional \code{COTAN} object}

\item{checkers}{a \code{list} of objects that defines the method, the thresholds
and the results of the checks to discriminate whether a \emph{cluster} is deemed
\emph{uniform transcript}.}

\item{df}{a \code{data.frame} with col-names being the member names and row-names
the names attached to each checker}

\item{checkerClass}{the type of the checker to be reconstructed from the
given \code{data.frame}}

\item{checker}{An checker object that defines how to check for \emph{uniform
transcript}. It is derived from \linkS4class{BaseUniformityCheck}}

\item{shift}{The amount by which to shift the \code{GDI} thresholds in the checker}
}
\value{
a copy of \code{currentC} with the results of the check. Note that the
slot \code{clusterSize} will be set to zero if it is not possible to get the
result of the check

a \code{data.frame} with col-names being the member names and row-names
the names attached to each checker

\code{dfToCheckers()} returns a \code{list} of checkers of the requested type,
each created from one of \code{data.frame} rows

\code{getCheckerThreshold()} returns the appropriate member of the
checker object representing the main \code{GDI} threshold

\code{calculateThresholdShiftToUniformity()} returns the positive shift
that would make the \verb{@isUniform} slot \code{TRUE} in the checker. It returns
zero if the result is already \code{TRUE} and \code{NaN} in case no such shift can
exist (e.g. the check have been not done yet)

\code{shiftCheckerThresholds()} returns a copy of the checker object
where all \code{GDI} thresholds have been shifted by the same given \code{shift}
amount
}
\description{
A hierarchy of classes to specify the method for checking
whether a \strong{cluster} has the \emph{Uniform Transcript} property. It also
doubles as result object.

\code{getCheckerThreshold()} extracts the main \code{GDI} threshold
from the given checker object

\code{calculateThresholdShiftToUniformity()} calculates by how much
the \code{GDI} thresholds in the given checker must be increased in order to
have that the relevant cluster is deemed \strong{uniform transcript}

\code{shiftCheckerThresholds()} returns a new checker object where
the \code{GDI} thresholds where increased in order to \emph{relax} the conditions to
achieve \strong{uniform transcript}
}
\details{
\code{BaseUniformityCheck} is the base class of the check methods

\code{GDICheck} represents a single unit check using \code{GDI} data. It
defaults to an \emph{above} check with threshold \eqn{1.4} and ratio \eqn{1\%}

\code{SimpleGDIUniformityCheck} represents the simplified (and legacy)
mechanism to determine whether a cluster has the \emph{Uniform Transcript}
property

The method is based on checking whether the fraction of the genes' \code{GDI}
below the given \emph{threshold} is less than the given \emph{ratio}

\code{AdvancedGDIUniformityCheck} represents the more precise and
advanced mechanism to determine whether a cluster has the \emph{Uniform
Transcript} property

The method is based on checking the genes' \code{GDI} against three
\emph{thresholds}: if a cluster fails the first \strong{below} check is deemed not
\emph{uniform}. Otherwise if it passes either of the other two checks (one above
and one below) it is deemed \emph{uniform}.

\code{checkObjIsUniform()} performs the check whether the given object is
uniform according to the given checker

\code{checkersToDF()} converts a \code{list} of checkers (i.e. objects that
derive from \code{BaseUniformityCheck}) into a \code{data.frame} with the values of
the members

\code{dfToCheckers()} converts a \code{data.frame} of checkers values into an
array of checkers ensuring given \code{data.frame} is compatible with member
types
}
\section{Slots}{

\describe{
\item{\code{isUniform}}{Logical. Output. The result of the check}

\item{\code{clusterSize}}{Integer. Output. The number of cells in the checked
cluster. When zero implies no check has been run yet}

\item{\code{isCheckAbove}}{Logical. Determines how to compare quantiles against given
thresholds. It is deemed passed if the relevant quantile is above/below the
given threshold}

\item{\code{GDIThreshold}}{Numeric. The level of \code{GDI} beyond which the \strong{cluster}
is deemed not uniform. Defaults}

\item{\code{maxRatioBeyond}}{Numeric. The maximum fraction of the empirical \code{GDI}
distribution that sits beyond the \code{GDI} threshold}

\item{\code{maxRankBeyond}}{Integer. The minimum rank in the empirical \code{GDI}
distribution for the \code{GDI} threshold}

\item{\code{fractionBeyond}}{Numeric. Output. The fraction of genes whose \code{GDI} is
above the threshold}

\item{\code{thresholdRank}}{Integer. Output. The rank that the \code{GDI} threshold would
have in the genes' \code{GDI} \code{vector}}

\item{\code{quantileAtRatio}}{Numeric. Output. The quantile in the genes' \code{GDI}
corresponding at the given ratio}

\item{\code{quantileAtRatio}}{Numeric. Output. The quantile in the genes' \code{GDI}
corresponding at the given rank}

\item{\code{check}}{\code{GDICheck}. The single threshold check used to determine whether
the \strong{cluster} is deemed not \emph{uniform}. Threshold defaults to \eqn{1.4},
\code{maxRatioBeyond} to \eqn{1\%}}

\item{\code{firstCheck}}{\code{GDICheck}. Single threshold below check used to determine
whether the \strong{cluster} is deemed not \emph{uniform}. Threshold defaults to
\eqn{1.297}, \code{maxRatioBeyond} to \eqn{5\%}}

\item{\code{secondCheck}}{\code{GDICheck}. Single threshold above check used to determine
whether the \strong{cluster} is deemed \emph{uniform}. Threshold defaults to
\eqn{1.307}, \code{maxRatioBeyond} to \eqn{2\%}}

\item{\code{thirdCheck}}{\code{GDICheck}. Single threshold below check used to determine
whether the \strong{cluster} is deemed \emph{uniform}. Threshold defaults to
\eqn{1.4},   \code{maxRatioBeyond} to \eqn{1\%}}

\item{\code{fourthCheck}}{\code{GDICheck}. Single threshold below check used to determine
whether the \strong{cluster} is deemed \emph{uniform}. Threshold defaults to
\eqn{1.4},   \code{maxRankBeyond} to \eqn{2}}
}}

