% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{HandleStrings}
\alias{HandleStrings}
\alias{handleNamesSubsets}
\alias{conditionsFromNames}
\alias{isEmptyName}
\alias{niceFactorLevels}
\alias{factorToVector}
\title{Handle names and factors' levels}
\usage{
handleNamesSubsets(names, subset = vector(mode = "character"))

conditionsFromNames(names, splitPattern = " ", fragmentNum = 2L)

isEmptyName(name)

niceFactorLevels(v)

factorToVector(f)
}
\arguments{
\item{names}{The full \code{list} of the names to handle}

\item{subset}{The names' subset. When empty all names are returned instead!}

\item{splitPattern}{the pattern to use to split the names}

\item{fragmentNum}{the string fragment to use as condition from the split
names}

\item{name}{the name to check}

\item{v}{an \code{array} or \code{factor} object}

\item{f}{a \code{factor} object}
}
\value{
\code{handleNamesSubsets()} returns the updated list of names' subset,
reordered according to the given names' list

\code{conditionsFromNames()} returns the extracted conditions

\code{isEmptyName()} returns whether the passed name is equivalent to an
empty string

\code{niceFactorLevels()} returns a \code{factor} that is preserving the
\emph{names} of the input with the new nicer levels

\code{factorToVector()} returns a \verb{character vector} that preserves the
\emph{names} of the input factor
}
\description{
Internal functions dedicated to solve strings or factors related
simple tasks
}
\details{
\code{handleNamesSubsets()} returns the given subset or the full \code{list}
of names if none were specified

\code{conditionsFromNames()} retrieves a condition from the given names
by picking the asked fragment after having them split according to the
given pattern

\code{isEmptyName()} returns whether the passed name is not null and has
non-zero characters

\code{niceFactorLevels()} provides \strong{nicer} \code{factor} labels that have
all the same number of characters

\code{factorToVector()} converts a \emph{named} \code{factor} to a \emph{named}
\verb{character vector}
}
