% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluo_est.R
\name{LocationMatrix}
\alias{LocationMatrix}
\title{LocationMatrix}
\usage{
LocationMatrix(data, filter.by = matrix(c("FDR", "Out.Index", 0.005,
  "confidence"), ncol = 2), report.by.signif = "max")
}
\arguments{
\item{data}{Data matrix. The matrix of the location and fluorescence signal estimates after two rounds (maximum)
of spotEstimator().}

\item{filter.by}{Data matrix. A series of filtering criteria and cut-offs that specify which samples are KEPT for
further analysis (see vignette). By default it flags by FDR (alpha = 0.005) and outlier index (keeps only the 'confident'
estimates).}

\item{report.by.signif}{Character string. It returns the pre-defined channel-specific signal-to-noise ratio and test
statistics for each sample. If "min", the algorithm only reports the P-values/FDRs and signal-to-noise of the channel
with the minimum signal-to-noise ratio. If "max", the algorithm only reports the P-values/FDRs and signal-to-noise of
the channel with the maximum signal-to-noise ratio.  Default is "max".}
}
\value{
List. The first component is a data matrix of the final table of estimates. The main body of this table has been generated by spotEstimator().
  It summarizes the location, the raw fluorescence signal estimates (foreground and background) and the quality control statistics. It keeps
  only the signal-to-noise ratio and the associated P-value/FDR of a predefined channel (see parameter report.by.signif). The last column
  ("Cells") consists of 1s for the samples that pass the filtering step (filter.by) and are used for further analysis. The rest of the samples
  are assigned 0s. The user should always inspect them along with the images to obtain the final list of samples to be used for further analysis.
  The second component is the date index for storing the output files. It is transfered to the next step.
}
\description{
It generates the final cell location and fluorescnece signal estimates and summarizes the quality
  control statistics.
}
\examples{
### the results matrix (column 'Cells') indicates three empty capture chambers
### (thus not only outliers were associated with the absense of a cell!)
Results <- LocationMatrix(data=estimates.2,
           filter.by = matrix(c("FDR","Out.Index",0.005,"confidence"),ncol=2))
}
