% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_fluo_NBE.R
\name{BatchFluo}
\alias{BatchFluo}
\title{BatchFluo}
\usage{
BatchFluo(data, maxMix, reference, prior.pi, flex.reps, flexmethod, seed)
}
\arguments{
\item{data}{List. A list of transformed and adjusted fluorescence signals.}

\item{maxMix}{Integer. The maximum number of components to fit into the mixture of
regressions model. If maxMix=1 or if the the optimal number of the estimated components
is 1, the model reduces to the classical 2-way ANOVA.}

\item{reference}{Numeric vector. Specifies the runs to be used as baseline (iteratively).}

\item{prior.pi}{Float. The prior probability to accept a component.}

\item{flex.reps}{Integer. The iterations of the Expectation-Maximization algorithm to estimate
the flexmix model.}

\item{flexmethod}{Character string. A method to estimate the optimal number of flexmix
components. One of "BIC", "AIC", "ICL".}

\item{seed}{Integer. An optional seed number for the Random Number Generator.}
}
\value{
A list of fluorescence signals, mixture components and flexmix model estimates
}
\description{
It performs the run effect correction of the cell fluorescence signals by flexmix or 2-way ANOVA.
}
\keyword{internal}
