% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{select_compass_pops}
\alias{select_compass_pops}
\title{Flag COMPASS boolean populations}
\usage{
select_compass_pops(cellpops, markers)
}
\arguments{
\item{cellpops}{\code{vector} of character names of cell populations.}

\item{markers}{\code{vector} of character names of markers in the order they appear in the population names.}
}
\value{
A boolean vector indexing \code{cellpops} with \code{TRUE} for populations matchin
the pattern.
}
\description{
Returns a boolean vector indexing cell populations in \code{cellpops} that match
the pattern for boolean combinations of \code{markers}.
}
\details{
If markers A, B, C, D make up the population names in \code{cellpops} and they
the names match the pattern e.g. "A+B-C+D+,Count" (typical of exports from some gating tools),
then \code{markers} should be a vector of markers in the same order they appear in \code{cellpops}.
}
\examples{
#Generate some population names
markers = LETTERS[1:4]
pos = c("+","-")
popnames = apply(expand.grid(pos,pos,pos,pos),1,
            function(x)paste(paste(paste(markers,x,sep=""),
            collapse=""),",Count",sep=""))
popnames = sample(c(popnames,paste(paste(markers,sample(c("+","-"),
             length(markers),replace=TRUE),sep=""),",Count",sep="")))
popnames[select_compass_pops(popnames,LETTERS[1:4])]
}
\seealso{
translate_marker_names
}
