% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVariantsForCNV.R
\name{plotVariantsForCNV}
\alias{plotVariantsForCNV}
\title{plotVariantsForCNV}
\usage{
plotVariantsForCNV(
  cnvfilter.results,
  cnv.id,
  points.cex = 1,
  points.pch = 19,
  legend.x.pos = 0.08,
  legend.y.pos = 0.25,
  legend.cex = 0.8,
  legend.text.width = NULL,
  legend.show = TRUE,
  karyotype.cex = 1,
  cnv.label.cex = 1,
  x.axis.bases.cex = 0.7,
  x.axis.bases.digits = 5,
  y.axis.title.cex = 0.8,
  y.axis.label.cex = 0.8,
  cnv.zoom.margin = TRUE
)
}
\arguments{
\item{cnvfilter.results}{S3 object returned by \code{filterCNVs} function}

\item{cnv.id}{CNV id for which to plot variants}

\item{points.cex}{Points cex (size). (Defaults to 1)}

\item{points.pch}{Points pch (symbol). (Defaults to 19)}

\item{legend.x.pos}{Legend x position. (Defaults to 0.08)}

\item{legend.y.pos}{Legend y position. (Defaults to 0.25)}

\item{legend.cex}{Legend cex. (Defaults to 0.8)}

\item{legend.text.width}{Legend text width (Defaults to NULL)}

\item{legend.show}{Whether to show the legend (Defaults to TRUE)}

\item{karyotype.cex}{karyotype cex: affects top title and chromosome text (at bottom). (Defaults to 1)}

\item{cnv.label.cex}{"CNV" text cex. (Defaults to 1)}

\item{x.axis.bases.cex}{X-axis bases position cex. (Defaults to 0.7)}

\item{x.axis.bases.digits}{X-axis bases position number of digits. (Defaults to 5)}

\item{y.axis.title.cex}{Y-axis title cex. (Defaults to 0.8)}

\item{y.axis.label.cex}{Y-axis labels cex. (Defaults to 0.8)}

\item{cnv.zoom.margin}{If TRUE, the zoom leaves an small margin at both sides of the CNV. False otherwise. (Defaults to TRUE)}
}
\value{
invisibly returns a \code{karyoplot} object
}
\description{
Plots a CNV with all the variants in it
}
\examples{
# Load CNVs data
cnvs.file <- system.file("extdata", "DECoN.CNVcalls.csv", package = "CNVfilteR", mustWork = TRUE)
cnvs.gr <- loadCNVcalls(cnvs.file = cnvs.file, chr.column = "Chromosome", start.column = "Start", end.column = "End", cnv.column = "CNV.type", sample.column = "Sample")

# Load VCFs data
vcf.files <- c(system.file("extdata", "variants.sample1.vcf.gz", package = "CNVfilteR", mustWork = TRUE),
               system.file("extdata", "variants.sample2.vcf.gz", package = "CNVfilteR", mustWork = TRUE))
vcfs <- loadVCFs(vcf.files, cnvs.gr = cnvs.gr)

# Filter CNVs
results <- filterCNVs(cnvs.gr, vcfs)

# Check CNVs that can be filtered out
as.data.frame(results$cnvs[results$cnvs$filter == TRUE])

# Plot one of them
plotVariantsForCNV(results, "3")


}
