% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCNORode.R
\name{runCNORode}
\alias{runCNORode}
\title{runCNORode}
\usage{
runCNORode(
  model,
  data,
  compression = TRUE,
  results_folder = "CNORode_results",
  cutNONC = TRUE,
  expansion = FALSE,
  LB_n = 1,
  LB_k = 0.1,
  LB_tau = 0.01,
  UB_n = 5,
  UB_k = 0.9,
  UB_tau = 10,
  default_n = 3,
  default_k = 0.5,
  default_tau = 1,
  opt_n = TRUE,
  opt_k = TRUE,
  opt_tau = TRUE,
  random = TRUE,
  maxeval = 1e+05,
  maxtime = 60,
  transfer_function = 3,
  nan_fac = 1,
  lambda_tau = 0,
  lambda_k = 0
)
}
\arguments{
\item{model}{A filename of prior knowledge network (PKN) in the SIF format}

\item{data}{A measurement filename in the MIDAS format}

\item{compression}{compress the prior knowledge network (TRUE), see \code{\link{preprocessing}}}

\item{results_folder}{results folder for the analysis.}

\item{cutNONC}{cut non-observable non-controllable node from PKN (TRUE), see \code{\link{preprocessing}}}

\item{expansion}{expand OR gates in the PKN (FALSE), see \code{\link{preprocessing}}}

\item{LB_n}{lower bound on parameter n, see \code{\link{createLBodeContPars}}}

\item{LB_k}{lower bound on parameter k, see \code{\link{createLBodeContPars}}}

\item{LB_tau}{lower bound on parameter tau, see \code{\link{createLBodeContPars}}}

\item{UB_n}{upper bound on parameter n, see \code{\link{createLBodeContPars}}}

\item{UB_k}{upper bound on parameter k, see \code{\link{createLBodeContPars}}}

\item{UB_tau}{upper bound on parameter tau, see \code{\link{createLBodeContPars}}}

\item{default_n}{default value of parameter n, see \code{\link{createLBodeContPars}}}

\item{default_k}{default value of parameter k, see \code{\link{createLBodeContPars}}}

\item{default_tau}{default value of parameter tau, see \code{\link{createLBodeContPars}}}

\item{opt_n}{should parameter n be optimised, see \code{\link{createLBodeContPars}}}

\item{opt_k}{should parameter k be optimised, see \code{\link{createLBodeContPars}}}

\item{opt_tau}{should parameter tau be optimised, see \code{\link{createLBodeContPars}}}

\item{random}{initial parameter vector generation (TRUE: random, FALSE: half of the LB-UB)}

\item{maxeval}{maximum number of funciton evaluations in the optimisation, see \code{\link{parEstimationLBodeSSm}}}

\item{maxtime}{maximum CPU time (in seconds) spent on optimisation before calling final refinement, see \code{\link{parEstimationLBodeSSm}}}

\item{transfer_function}{trandfer function types represented by the edges, see \code{\link{parEstimationLBodeSSm}}}

\item{nan_fac}{penalty for NA simulations, see \code{\link{parEstimationLBodeSSm}}}

\item{lambda_tau}{regularisation penalty for tau parameters, see \code{\link{parEstimationLBodeSSm}}}

\item{lambda_k}{regularisation penalty for k parameters for optimisation, see \code{\link{parEstimationLBodeSSm}}}
}
\description{
A one-line wrapper of the CNORode pipeline
}
\examples{
\dontrun{
model = system.file("extdata", "ToyModelMMB_FeedbackAnd.sif",package="CNORode")
data = system.file("extdata", "ToyModelMMB_FeedbackAnd.csv", package="CNORode")
res = runCNORode(model,data,results_folder = "./results")
}
}
