% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DatasetGenerator.R
\name{perturb_dataset}
\alias{perturb_dataset}
\title{Perturbate a boolean matrix}
\usage{
perturb_dataset(dataset, FP_rate = 0, FN_rate = 0, MIS_rate = 0)
}
\arguments{
\item{dataset}{a matrix/sparse matrix}

\item{FP_rate}{False Positive rate}

\item{FN_rate}{False Negative rate}

\item{MIS_rate}{Missing Data rate}
}
\value{
the new, perturbed, matrix
}
\description{
Given a boolean matrix, randomly 
add False Positives (FP), False Negatives (FN) and Missing data 
following user defined rates. In the final matrix, missing 
data is represented by the value 3.
}
\details{
Note that CIMICE does not support dataset with missing data natively, 
so using MIS_rate != 0 will then require some pre-processing.
}
\examples{
require(dplyr)

example_dataset() \%>\%
  make_generator_stub() \%>\% 
  set_generator_edges(
    list(
      "D", "A, D", 1 , 
      "A", "A, D", 1 , 
      "A, D", "A, C, D", 1 , 
      "A, D", "A, B, D", 1 , 
      "Clonal", "D", 1 , 
      "Clonal", "A", 1 , 
      "D", "D", 1 , 
      "A", "A", 1 , 
      "A, D", "A, D", 1 , 
      "A, C, D", "A, C, D", 1 , 
      "A, B, D", "A, B, D", 1 , 
      "Clonal", "Clonal", 1 
  )) \%>\% 
  finalize_generator \%>\% 
  simulate_generator(3, 10) \%>\% 
  perturb_dataset(FP_rate = 0.01, FN_rate = 0.1, MIS_rate = 0.12)

}
