% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{build_topology_subset}
\alias{build_topology_subset}
\title{Compute subset relation as edge list}
\usage{
build_topology_subset(samples)
}
\arguments{
\item{samples}{input dataset (mutational matrix) as matrix}
}
\value{
the computed edge list
}
\description{
Create an edge list E representing the
'subset' relation for binary strings so that:
\deqn{ (A,B) in E <=> forall(i) : A[i] -> B[i] }
}
\examples{
require(dplyr)
preproc <- example_dataset() \%>\% dataset_preprocessing
samples <- preproc[["samples"]]
freqs   <- preproc[["freqs"]]
labels  <- preproc[["labels"]]
genes   <- preproc[["genes"]]
build_topology_subset(samples)

}
