% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{plot_sample_tree}
\alias{plot_sample_tree}
\alias{plot_sample_tree,CEMiTool-method}
\title{Sample clustering}
\usage{
plot_sample_tree(cem, ...)

\S4method{plot_sample_tree}{CEMiTool}(
  cem,
  col_vector = NULL,
  sample_name_column = NULL,
  class_column = NULL,
  filter = FALSE
)
}
\arguments{
\item{cem}{Object of class \code{CEMiTool} or \code{data.frame}.}

\item{...}{Optional parameters.}

\item{col_vector}{A vector of columns to use for visualizing the clustering. See Details.}

\item{sample_name_column}{A string specifying the column to be used as sample identification.
For CEMiTool objects, this will be the string specified in the sample_name_column slot.}

\item{class_column}{A string specifying the column to be used as sample group identification.
For CEMiTool objects, this will be the string specified in the class_column slot.}

\item{filter}{Logical. Whether or not to use filtered data for CEMiTool objects (Default: FALSE).}
}
\value{
Object of class \code{CEMiTool} with dendrogram or a plot object.
}
\description{
Creates a dendrogram showing the similarities between samples in the expression data.
}
\examples{
# Get example CEMiTool object
data(cem)
# Plot sample dendrogram
cem <- plot_sample_tree(cem)
# Check resulting plot
show_plot(cem, "sample_tree")

}
