% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_mean_k}
\alias{plot_mean_k}
\alias{plot_mean_k,CEMiTool-method}
\title{Network mean connectivity}
\usage{
plot_mean_k(cem, ...)

\S4method{plot_mean_k}{CEMiTool}(cem, title = "Mean connectivity")
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}.}

\item{...}{Optional parameters.}

\item{title}{title of the graph}
}
\value{
Object of class \code{CEMiTool} with connectivity plot
}
\description{
Creates a graph showing the mean connectivity of genes in the network
}
\examples{
# Get example CEMiTool object
data(cem)
# Plot scale-free model fit as a function of the soft-thresholding beta parameter choice
cem <- plot_mean_k(cem)
# Check resulting plot
show_plot(cem, "mean_k")

}
