% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbMDS.R
\name{pbMDS}
\alias{pbMDS}
\title{Pseudobulk-level MDS plot}
\usage{
pbMDS(
  x,
  by = c("sample_id", "cluster_id", "both"),
  k = "meta20",
  dims = c(1, 2),
  features = NULL,
  assay = "exprs",
  fun = c("median", "mean", "sum"),
  color_by = switch(by, sample_id = "condition", "cluster_id"),
  label_by = if (by == "sample_id") "sample_id" else NULL,
  shape_by = NULL,
  size_by = is.null(shape_by),
  pal = if (color_by == "cluster_id") .cluster_cols else NULL
)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{by}{character string specifying whether to aggregate 
by \code{sample_id}, \code{cluster_id} or \code{both}.}

\item{k}{character string specifying which clustering to use when 
\code{by != "sample_id"}; valid values are \code{names(cluster_codes(x))}.}

\item{dims}{two numeric scalars indicating which dimensions to plot.}

\item{features}{character string specifying which features to include
for computation of reduced dimensions; valid values are 
\code{"type"/"state"} for \code{type/state_markers(x)} 
if \code{rowData(x)$marker_class} have been specified; 
a subset of \code{rownames(x)}; NULL to use all features.}

\item{assay}{character string specifying which assay data to use;
valid values are \code{assayNames(x)}.}

\item{fun}{character string specifying which summary statistic to use.}

\item{color_by}{character string specifying a 
non-numeric cell metadata column to color by; 
valid values are \code{names(colData(x))}.}

\item{label_by}{character string specifying a 
non-numeric cell metadata column to label by; 
valid values are \code{names(colData(x))}.}

\item{shape_by}{character string specifying a 
non-numeric cell metadata column to shape by; 
valid values are \code{names(colData(x))}.}

\item{size_by}{logical specifying whether points should be 
sized by the number of cells that went into aggregation; i.e., 
the size of a give sample, cluster or cluster-sample instance.}

\item{pal}{character vector of colors to use; 
NULL for default \code{ggplot2} colors.}
}
\value{
a \code{ggplot} object.
}
\description{
Pseudobulk-level Multi-Dimensional Scaling (MDS) 
plot computed on median marker expressions in each sample.
}
\examples{
data(PBMC_fs, PBMC_panel, PBMC_md)
sce <- prepData(PBMC_fs, PBMC_panel, PBMC_md)
sce <- cluster(sce)

# sample-level pseudobulks
# including state-markers only
pbMDS(sce, by = "sample_id", features = "state")

# cluster-level pseudobulks
# including type-features only
pbMDS(sce, by = "cluster_id", features = "type")

# pseudobulks by cluster-sample 
# including all features
pbMDS(sce, by = "both", k = "meta12", 
  shape_by = "condition", size_by = TRUE)

}
\references{
Nowicka M, Krieg C, Crowell HL, Weber LM et al. 
CyTOF workflow: Differential discovery in 
high-throughput high-dimensional cytometry datasets.
\emph{F1000Research} 2017, 6:748 (doi: 10.12688/f1000research.11622.1)
}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
