% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractClusters.R
\name{extractClusters}
\alias{extractClusters}
\title{Extract clusters from a \code{SingleCellExperiment}}
\usage{
extractClusters(
  x,
  k,
  clusters = NULL,
  as = c("flowSet", "fcs"),
  out_dir = ".",
  verbose = TRUE
)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{k}{numeric or character string. 
Specifies the clustering to extract populations from.
Must be one of \code{names(cluster_codes(x))}.}

\item{clusters}{a character vector.
Specifies which clusters to extract.
\code{NULL} = all clusters.}

\item{as}{\code{"flowSet"} or \code{"fcs"}. 
Specifies whether clusters should be return 
as a \code{flowSet} or written to FCS files.}

\item{out_dir}{a character string.
Specifies where FCS files should be writen to.
Defaults to the working directory.}

\item{verbose}{logical.
Should information on progress be reported?}
}
\value{
a \code{flowSet} or character vector of the output file names.
}
\description{
Extracts clusters from a \code{SingleCellExperiment}. 
Populations will be either returned as a \code{flowSet} 
or written to FCS files, depending on argument \code{as}.
}
\examples{
# construct SCE & run clustering
data(PBMC_fs, PBMC_panel, PBMC_md, merging_table)
sce <- prepData(PBMC_fs, PBMC_panel, PBMC_md)
sce <- cluster(sce)

# merge clusters
sce <- mergeClusters(sce, k="meta20", table=merging_table, id="merging_1")
extractClusters(sce, k="merging_1", clusters=c("NK cells", "surface-"))

}
\author{
Mark D Robinson & Helena L Crowell \email{helena.crowell@uzh.ch}
}
