% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetMethods.R
\name{setColors}
\alias{setColors}
\alias{setColors,CAGEr-method}
\title{Set colors for samples}
\usage{
setColors(object, colors = NULL)

\S4method{setColors}{CAGEr}(object, colors = NULL)
}
\arguments{
\item{object}{A \code{\link{CAGEr}} object.}

\item{colors}{A character vector of one valid \R color specification per
sample (see \code{\link{col2rgb}} for details).  Provided colors are
assigned to samples in the order they are returned by the
\code{\link{sampleLabels}} function.}
}
\value{
Assigns one color to each sample in the CAGEr object and modifies it
in place.
}
\description{
Assigns one color to each sample in the CAGEr object.  These
colors are used in various plots and exported tracks to consistently
represent corresponding samples.
}
\examples{

sampleLabels(exampleCAGEexp)
setColors(exampleCAGEexp, 5)
sampleLabels(exampleCAGEexp)
setColors(exampleCAGEexp, c("#ff0000ff", "#CCFF00", "blue", "grey", 1))
sampleLabels(exampleCAGEexp)
setColors(exampleCAGEexp, c("red", "darkgreen", "blue", "grey", "black"))
sampleLabels(exampleCAGEexp)

}
\seealso{
Other CAGEr setter methods: 
\code{\link{genomeName}()},
\code{\link{inputFiles}()},
\code{\link{inputFilesType}()},
\code{\link{sampleLabels}()}
}
\author{
Vanja Haberle
}
\concept{CAGEr setter methods}
