% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMethods.R, R/SetMethods.R
\name{seqNameTotalsSE}
\alias{seqNameTotalsSE}
\alias{seqNameTotalsSE,CAGEexp-method}
\alias{seqNameTotalsSE<-}
\title{Retreives the SummarizedExperiment containing chromosome expression totals.}
\usage{
seqNameTotalsSE(object)

\S4method{seqNameTotalsSE}{CAGEexp}(object)

seqNameTotalsSE(object) <- value
}
\arguments{
\item{object}{A \code{CAGEexp} object.}

\item{value}{A SummarizedExperiment object where rows represent reference sequences
such as chromosomes.}
}
\description{
Get or set a \code{SummarizedExperiment} summarising whole-chromosome
expression levels in the experiment slot \code{seqNameTotals} and the sample metadata
of the \code{\link{CAGEexp}} object.
}
\examples{
seqNameTotalsSE(exampleCAGEexp)

}
\seealso{
summariseChrExpr

Other CAGEr accessor methods: 
\code{\link{CTSScoordinatesGR}()},
\code{\link{CTSScumulativesTagClusters}()},
\code{\link{CTSSnormalizedTpmDF}()},
\code{\link{CTSStagCountDF}()},
\code{\link{GeneExpDESeq2}()},
\code{\link{GeneExpSE}()},
\code{\link{consensusClustersGR}()},
\code{\link{expressionClasses}()},
\code{\link{filteredCTSSidx}()},
\code{\link{genomeName}()},
\code{\link{inputFiles}()},
\code{\link{inputFilesType}()},
\code{\link{librarySizes}()},
\code{\link{sampleLabels}()},
\code{\link{tagClustersGR}()}
}
\author{
Charles Plessy
}
\concept{CAGEr accessor methods}
