% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMethods.R, R/SetMethods.R
\name{inputFiles}
\alias{inputFiles}
\alias{inputFiles,CAGEexp-method}
\alias{inputFiles<-}
\alias{inputFiles<-,CAGEexp-method}
\title{Extracting paths to input files from CAGEr objects}
\usage{
inputFiles(object)

\S4method{inputFiles}{CAGEexp}(object)

inputFiles(object) <- value

\S4method{inputFiles}{CAGEexp}(object) <- value
}
\arguments{
\item{object}{A CAGEexp object.}

\item{value}{A character vector with one file path per sample.}
}
\value{
Returns a character vector of paths to CAGE data input files.
}
\description{
Extracts the paths to CAGE data input files from
\code{\link{CAGEexp}} objects.
}
\examples{
inputFiles(exampleCAGEexp)

}
\seealso{
Other CAGEr accessor methods: 
\code{\link{CTSScoordinatesGR}()},
\code{\link{CTSScumulativesTagClusters}()},
\code{\link{CTSSnormalizedTpmDF}()},
\code{\link{CTSStagCountDF}()},
\code{\link{GeneExpDESeq2}()},
\code{\link{GeneExpSE}()},
\code{\link{consensusClustersGR}()},
\code{\link{expressionClasses}()},
\code{\link{filteredCTSSidx}()},
\code{\link{genomeName}()},
\code{\link{inputFilesType}()},
\code{\link{librarySizes}()},
\code{\link{sampleLabels}()},
\code{\link{seqNameTotalsSE}()},
\code{\link{tagClustersGR}()}

Other CAGEr setter methods: 
\code{\link{genomeName}()},
\code{\link{inputFilesType}()},
\code{\link{sampleLabels}()},
\code{\link{setColors}()}
}
\author{
Vanja Haberle

Charles Plessy
}
\concept{CAGEr accessor methods}
\concept{CAGEr setter methods}
