% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BumpyMatrix.R
\docType{class}
\name{BumpyMatrix}
\alias{BumpyMatrix}
\alias{BumpyMatrix-class}
\alias{show,BumpyMatrix-method}
\alias{[,BumpyMatrix,ANY,ANY,ANY-method}
\alias{[,BumpyMatrix,ANY-method}
\alias{[,BumpyMatrix,BumpyMatrix,ANY,ANY-method}
\alias{[,BumpyMatrix,BumpyMatrix-method}
\alias{[<-,BumpyMatrix,ANY,ANY,CompressedList-method}
\alias{[<-,BumpyMatrix,ANY,ANY,BumpyMatrix-method}
\alias{dim,BumpyMatrix-method}
\alias{length,BumpyMatrix-method}
\alias{dimnames,BumpyMatrix-method}
\alias{dimnames<-,BumpyMatrix,ANY-method}
\alias{rbind,BumpyMatrix-method}
\alias{cbind,BumpyMatrix-method}
\alias{t,BumpyMatrix-method}
\alias{undim}
\alias{undim,BumpyMatrix-method}
\alias{redim}
\alias{redim,CompressedList,BumpyMatrix-method}
\alias{unlist,BumpyMatrix-method}
\alias{lengths,BumpyMatrix-method}
\title{The BumpyMatrix class}
\description{
The BumpyMatrix provides a two-dimensional object where each entry is a \linkS4class{Vector} object.
This is useful for storing data that has a variable number of observations per sample/feature combination,
e.g., for inclusion as another assay in a SummarizedExperiment object.
}
\section{Constructor}{

\code{BumpyMatrix(x, dims, dimnames=list(NULL, NULL), proxy=NULL, reorder=TRUE)} will produce a BumpyMatrix object, given:
\itemize{
\item \code{x}, a \linkS4class{CompressedList} object containing one or more \linkS4class{DFrame}s or atomic vectors.
\item \code{dim}, an integer vector of length 2 specifying the dimensions of the returned object.
\item \code{dimnames}, a list of length 2 containing the row and column names.
\item \code{proxy}, an integer or numeric matrix-like object specifying the location of each entry of \code{x} in the output matrix.
\item \code{reorder}, a logical scalar indicating whether \code{proxy} (if specified) should be reordered.
}
The type of the returned BumpyMatrix object is determined from the type of \code{x}.

If \code{proxy=NULL}, \code{x} should have length equal to the product of \code{dim}.
The entries of the returned BumpyMatrix are filled with \code{x} in a column-major manner.

If \code{proxy} is specified, it should contain indices in \code{1:length(x)} with all other entries filled with zeros.
If \code{reorder=FALSE}, all non-zero values should be in increasing order when encountered in column-major format;
otherwise, the indices are resorted to enforce this expectation.
Note that \code{dims} and \code{dimnames} are ignored.

If \code{x} is missing, a \linkS4class{BumpyIntegerMatrix} is returned with zero rows and columns.
If \code{dim} is also specified, a BumpyIntegerMatrix with the specified number of rows and columns is returned,
where each entry is an empty integer vector.
}

\section{Basic matrix methods}{

In the following code snippets, \code{x} is an instance of a BumpyMatrix subclass.

\code{dim(x)} will yield a length-2 integer vector containing the number of rows and columns in \code{x}.
\code{length(x)} will yield the product of the number of columns and rows.

\code{dimnames(x)} will yield a list of two character vectors with the row and column names of \code{x}.
Either or both elements of the list may be \code{NULL} if no names are present.

\code{x[i, j, ..., drop=TRUE]} will yield the specified submatrix of the same type as \code{x},
given integer, character or logical subsetting vectors in \code{i} and \code{j}.
If the resulting submatrix has any dimension of length 1 and \code{drop=TRUE},
a \linkS4class{CompressedList} of the appropriate type is instead returned.

\code{x[i,j] <- value} will replace the specified entries in \code{x} with the values in another BumpyMatrix \code{value}.
It is expected that \code{value} is of the same subclass as \code{x}.
\code{value} can also be a \link{CompressedList} of the same class as \code{undim(x)},
in which case it is recycled to fill the specified entries.

\code{t(x)} will transpose the BumpyMatrix, returning an object of the same type.

\code{rbind(..., deparse.level=1)} and \code{cbind(..., deparse.level=1)} will combine all BumpyMatrix objects in \code{...},
yielding a single BumpyMatrix object containing all the rows and columns, respectively.
All objects should have the same number of columns (for \code{rbind}) or rows (for \code{cbind}).
}

\section{Subsetting by another BumpyMatrix}{

Given a BumpyMatrix \code{x} and an appropriate BumpyMatrix \code{i},
\code{x[i]} will return another BumpyMatrix where each entry of \code{x} is subsetted by the corresponding entry of \code{i}.
This usually requires \code{i} to be a BumpyIntegerMatrix or a BumpyLogicalMatrix,
though it is also possible to use a BumpyCharacterMatrix if each entry of \code{x} is named.
}

\section{Special CompressedList methods}{

\code{undim(x)} will return the underlying \linkS4class{CompressedList} object.

\code{redim(flesh, skeleton)} will create a BumpyMatrix object, given a CompressedList \code{flesh} and an existing BumpyMatrix object \code{skeleton}.
\code{flesh} is assumed to be of the same length as \code{undim(skeleton)} where each entry in the former replaces the corresponding entry in the latter.
The class of the output is determined based on the class of \code{flesh}.
This method is analogous to the \code{\link{relist}} function for lists.

\code{unlist(x, ...)} will return the underlying \linkS4class{Vector} used to create the \linkS4class{CompressedList} object.
This is the same as \code{unlist(undim(x), ...)}.
}

\section{Other methods}{

\code{lengths(x)} will return a numeric matrix-like object with the same dimensions and dimnames as \code{x},
where each entry contains the length of the corresponding entry in \code{x}.
The output class can be anything used in the \code{proxy} of the constructor, e.g., a sparse matrix from the \pkg{Matrix} package.
}

\examples{
# Mocking up a BumpyNumericList:
library(IRanges)
x <- NumericList(split(runif(1000), factor(sample(50, 1000, replace=TRUE), 1:50)))  
length(x)

# Creating a BumpyNumericMatrix:
mat <- BumpyMatrix(x, c(10, 5))
mat

# Standard subsetting works correctly:
mat[1:10,1:2]
mat[,1]
mat[1,]

# Subsetting by another BumpyMatrix.
is.big <- x > 0.9
i <- BumpyMatrix(is.big, dim(mat))
out <- mat[i]
out # same dimensions as mat...
out[,1] # but the entries are subsetted.
out[1,]

# Subset replacement works correctly:
mat[,2]
alt <- mat
alt[,2] <- mat[,1,drop=FALSE]
alt[,2]

# Combining works correctly:
rbind(mat, mat)
cbind(mat, mat)

# Transposition works correctly:
mat[1,2]
tmat <- t(mat)
tmat
tmat[1,2]

# Get the underlying objects:
undim(mat)
summary(unlist(mat))

}
\author{
Aaron Lun
}
