% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc.R
\docType{data}
\name{BreastSubtypeRobj}
\alias{BreastSubtypeRobj}
\title{BreastSubtypeRobj: Resources for NC-based methods}
\format{
A list with:
\describe{
\item{\code{medians}}{Matrix/data frame of platform-specific medians
for \strong{11} expression/sequencing platforms, derived as described in
Picornell et al. (2019). Platform columns include:
\code{nCounter},
\code{totalRNA.FFPE.20151111}, \code{RNAseq.Freeze.20120907}, \code{RNAseq.V2}, \code{RNAseq.V1},
\code{GC.4x44Kcustom}, \code{Agilent_244K}, \code{commercial_1x44k_postMeanCollapse_WashU}, \code{commercial_4x44k_postMeanCollapse_WashU_v2},
\code{htp1.5_WU_update}, \code{arrayTrain_postMeanCollapse}.}
\item{\code{centroid}}{PAM50 centroids used by \code{parker.original}.}
\item{\code{genes.sig50}}{Data frame of the 50 PAM50 genes with a proliferation flag.}
\item{\code{ssBC.subgroupQuantile}}{Subgroup-specific quantiles used by \code{ssBC}.}
\item{\code{genes.signature}}{Marker genes used across NC- and SSP-based methods.}
\item{\code{UNC232}}{Summary data for the UNC232 training cohort.}
\item{\code{platform.UNC232}}{Platform annotation for UNC232.}
}
}
\usage{
data("BreastSubtypeRobj")
}
\description{
List of reference resources required by nearest-centroid (NC) subtyping
methods: platform medians, centroids, signatures, subgroup quantiles, and
metadata from the UNC232 training cohort.
}
\examples{
library(BreastSubtypeR)
data("BreastSubtypeRobj")
}
\references{
Parker JS, Mullins M, Cheung MCU, Leung S, Voduc D, et al.
Supervised risk predictor of breast cancer based on intrinsic subtypes.
\emph{J Clin Oncol}. 2009;27(8):1160–1167. https://doi.org/10.1200/JCO.2008.18.1370

Zhao X, Rodland EA, Tibshirani R, Plevritis S.
Molecular subtyping for clinically defined breast cancer subgroups.
\emph{Breast Cancer Res}. 2015;17(1):29. https://doi.org/10.1186/s13058-015-0520-4

Fernandez-Martinez A, Krop IE, Hillman DW, Polley MY, Parker JS, Huebner L, et al.
Survival, pathologic response, and genomics in CALGB 40601 (Alliance).
\emph{J Clin Oncol}. 2020;38(36):4184–4197. https://doi.org/10.1200/JCO.20.01276

Picornell AC, Echavarria I, Alvarez E, López-Tarruella S, Jerez Y, Hoadley K, et al.
Breast cancer PAM50 signature: correlation and concordance between RNA-seq and digital multiplexed gene expression technologies in a TNBC series.
\emph{BMC Genomics}. 2019;20(1):452. https://doi.org/10.1186/s12864-019-5849-0
}
\keyword{datasets}
