% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Individualcomparison.R
\name{Individualcomparison}
\alias{Individualcomparison}
\title{Individual single sample analysis}
\usage{
Individualcomparison(
  data.matrix,
  sample_info = NULL,
  FC = NULL,
  DIFF = NULL,
  Group_column = NULL,
  Ref_group = NULL,
  SummarizedExperiment = TRUE
)
}
\arguments{
\item{data.matrix}{Matrix of normalized expression data (not Log2 transformed).Row names are required to be valid Gene Symbols. Columns names are sample IDs
or data.matrix can also be given a summarizedexperiment object and assigned data.matrix and sample_info accordingly from the object.}

\item{sample_info}{A dataframe with sample annotation.}

\item{FC}{Numeric value specifying the foldchange cut off that will be applied to define increase or decrease of a given transcript compared to the reference group}

\item{DIFF}{Numeric value specifying the difference cut off that will be applied to define increase or decrease of a given transcript compared to the reference group}

\item{Group_column}{Character vector identical to the column name from sample_info dataframe that specifies group annotation used for the analysis}

\item{Ref_group}{Character vector specifying value within the group column that will be used as Reference group}

\item{SummarizedExperiment}{Output data as the SummarizedExperiment class when SummarizedExperiment = TRUE}
}
\value{
\preformatted{         A matrix of the percentahe of module response at individual level and SummarizedExperiment object
}
}
\description{
The Individualcomparison function will perform individual sample comparison analysis in reference to a control sample or group of samples, with the results are expressed “at the module level” as percent of genes increased or decreased.
}
\details{
\itemize{
\item Expression matrix and sample annotation file are required in order to perform this analysis.
\item The sample annotation file must be loaded using a specific name = "sample_info".
\item The names of the columns for the conditions used in the analysis must be specified
\item The default cutoff is set at FC =1.5 and DIFF =10
}
}
\examples{
## data could be downloaded from ExperimentHub("GSE13015")
library(ExperimentHub)
library(SummarizedExperiment)
dat = ExperimentHub()
res = query(dat , "GSE13015")
GSE13015 = res[["EH5429"]]
Individual_df = Individualcomparison(GSE13015, sample_info = NULL,
                                    FC = 1.5, DIFF = 10, Group_column = "Group_test",
                                    Ref_group = "Control")
}
\author{
Darawan Rinchai \href{mailto:drinchai@gmail.com}{drinchai@gmail.com}
}
