% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/queryKNN.R
\name{queryKnnFromIndex}
\alias{queryKnnFromIndex}
\alias{queryKNN}
\alias{queryKNN,matrix,ANY-method}
\alias{queryKNN,BiocNeighborGenericIndex,ANY-method}
\alias{queryKNN,missing,ANY-method}
\alias{queryKNN,matrix-method}
\alias{queryKNN,BiocNeighborGenericIndex-method}
\alias{queryKNN,missing-method}
\alias{queryKnnFromIndex,BiocNeighborGenericIndex-method}
\title{Query k-nearest neighbors}
\usage{
queryKnnFromIndex(
  BNINDEX,
  query,
  k,
  get.index = TRUE,
  get.distance = TRUE,
  num.threads = 1,
  subset = NULL,
  transposed = FALSE,
  ...
)

\S4method{queryKnnFromIndex}{BiocNeighborGenericIndex}(
  BNINDEX,
  query,
  k,
  get.index = TRUE,
  get.distance = TRUE,
  num.threads = 1,
  subset = NULL,
  transposed = FALSE,
  ...,
  .check.nonfinite = TRUE
)

queryKNN(
  X,
  query,
  k,
  get.index = TRUE,
  get.distance = TRUE,
  num.threads = 1,
  subset = NULL,
  transposed = FALSE,
  ...,
  BPPARAM = NULL,
  BNPARAM = NULL
)
}
\arguments{
\item{BNINDEX}{A \linkS4class{BiocNeighborIndex} object, typically created by \code{\link{buildIndex}}.}

\item{query}{A numeric matrix or matrix-like object of query points, containing the same number of columns as \code{X}.}

\item{k}{A positive integer scalar specifying the number of nearest neighbors to retrieve.

Alternatively, an integer vector of length equal to the number of points in \code{query}, specifying the number of neighbors to identify for each point.
If \code{subset} is provided, this should have length equal to the length of \code{subset}.
Users should wrap this vector in an \link{AsIs} class to distinguish length-1 vectors from integer scalars.

All \code{k} should be less than or equal to the number of points in \code{X}, otherwise the former will be capped at the latter with a warning.}

\item{get.index}{A logical scalar indicating whether the indices of the nearest neighbors should be recorded.
Setting this to \code{FALSE} improves efficiency if the indices are not of interest.

Alternatively, if \code{k} is an integer scalar, this may be a string containing \code{"normal"} or \code{"transposed"}.
The former is the same as \code{TRUE}, while the latter returns the index matrix in transposed format.}

\item{get.distance}{A logical scalar indicating whether distances to the nearest neighbors should be recorded.
Setting this to \code{FALSE} improves efficiency if the distances are not of interest.

Alternatively, if \code{k} is an integer scalar, this may be a string containing \code{"normal"} or \code{"transposed"}.
The former is the same as \code{TRUE}, while the latter returns the distance matrix in transposed format.}

\item{num.threads}{Integer scalar specifying the number of threads to use for the search.}

\item{subset}{An integer, logical or character vector indicating the rows of \code{query} (or columns, if \code{transposed=TRUE}) for which the nearest neighbors should be identified.}

\item{transposed}{A logical scalar indicating whether \code{query} is transposed, in which case it contains dimensions in the rows and data points in the columns.
For \code{queryKNN}, settting \code{transposed=TRUE} also indicates that \code{X} is also transposed.}

\item{...}{For \code{queryKnnFromIndex}, further arguments to pass to individual methods.
If a method accepts arguments here, it should prefix these arguments with the algorithm name to avoid conflicts, e.g., \code{vptree.foo.bar}.

For \code{queryKNN}, further arguments to pass to \code{queryKnnFromIndex}.
These are also passed to \code{\link{buildIndex}} when \code{X} is not an external pointer.}

\item{.check.nonfinite}{Boolean indicating whether to check for non-finite values in \code{query}.
This can be set to \code{FALSE} for greater efficiency.}

\item{X}{The reference dataset to be queried.
This should be a numeric matrix or matrix-like object where rows correspond to reference points and columns correspond to variables (i.e., dimensions).
Alternatively, a prebuilt \linkS4class{BiocNeighborIndex} object from \code{\link{buildIndex}}.}

\item{BPPARAM}{Soft-deprecated, use \code{num.threads} instead.}

\item{BNPARAM}{A \linkS4class{BiocNeighborParam} object specifying how the index should be constructed.
If \code{NULL}, this defaults to a \linkS4class{KmknnParam}.
Ignored if \code{X} contains a prebuilt index.}
}
\value{
List containing \code{index} (if \code{get.index} is not \code{FALSE}) and \code{distance} (if \code{get.distance} is not \code{FALSE}).
\itemize{
\item 
If \code{get.index=TRUE} or \code{"normal"} and \code{k} is an integer scalar,
\code{index} is an integer matrix with \code{k} columns where each row corresponds to a point (denoted here as \eqn{i}) in \code{query}.
The \eqn{i}-th row contains the indices of points in \code{X} that are the nearest neighbors to point \eqn{i}, sorted by increasing distance from \eqn{i}.

If \code{get.index=FALSE} or \code{"transposed"} and \code{k} is an integer scalar,
\code{index} is as described above but transposed, i.e., the \code{i}-th column contains the indices of neighboring points in \code{X}. 

\item 
If \code{get.distance=TRUE} or \code{"normal"} and \code{k} is an integer scalar,
\code{distance} is a numeric matrix of the same dimensions as \code{index}.
The \eqn{i}-th row contains the distances of neighboring points in \code{X} to the point \eqn{i}, sorted in increasing order.

If \code{get.distance=FALSE} or \code{"transposed"} and \code{k} is an integer scalar,
\code{distance} is as described above but transposed, i.e., the \code{i}-th column contains the distances to neighboring points in \code{X}. 

\item 
If \code{get.index} is not \code{FALSE} and \code{k} is an integer vector,
\code{index} is a list of integer vectors where each vector corresponds to a point (denoted here as \eqn{i}) in \code{X}.
The \eqn{i}-th vector has length \code{k[i]} and contains the indices of points in \code{X} that are the nearest neighbors to point \eqn{i}, sorted by increasing distance from \eqn{i}.

\item 
If \code{get.distance} is not \code{FALSE} and \code{k} is an integer vector,
\code{distance} is a list of numeric vectors of the same lengths as those in \code{index}.
The \eqn{i}-th vector contains the distances of neighboring points in \code{X} to the point \eqn{i}, sorted in increasing order.
}
}
\description{
Query a reference dataset for the k-nearest neighbors of each point in a query dataset.
}
\details{
If multiple queries are to be performed to the same \code{X}, it may be beneficial to build the index from \code{X} with \code{\link{buildIndex}}.
The resulting pointer object can be supplied as \code{X} to multiple \code{queryKNN} calls, avoiding the need to repeat index construction in each call.
}
\examples{
Y <- matrix(rnorm(100000), ncol=20)
Z <- matrix(rnorm(20000), ncol=20)
out <- queryKNN(Y, query=Z, k=5)
head(out$index)
head(out$distance)

}
\seealso{
\code{\link{buildIndex}}, to build an index ahead of time.

\code{\link{queryDistance}}, to obtain the distance from each query point to its k-th nearest neighbor.
}
\author{
Aaron Lun
}
