% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readGFF.R
\name{readGFF}
\alias{readGFF}
\alias{GFFcolnames}
\title{Reads a file in GFF format}
\usage{
GFFcolnames(GFF1 = FALSE)

readGFF(
  filepath,
  version = 0,
  columns = NULL,
  tags = NULL,
  filter = NULL,
  nrows = -1,
  raw_data = FALSE
)
}
\arguments{
\item{GFF1}{\code{logical(1)} Use "group" instead of "attributes" for the 9th
column name. Default is \code{FALSE}.}

\item{filepath}{A single string containing the path or URL to the file to
read. Alternatively can be a connection.}

\item{version}{\code{readGFF} should do a pretty descent job at detecting
the GFF version. Use this argument \emph{only} if it doesn't or if you want
to force it to parse and import the file as if its 9-th column was in a
different format than what it really is (e.g. specify \code{version=1} on a
GTF or GFF3 file to interpret its 9-th column as the \code{"group"} column
of a GFF1 file). Supported versions are 1, 2, and 3.}

\item{columns}{The standard GFF columns to load. All of them are loaded by
default.}

\item{tags}{The tags to load. All of them are loaded by default.}

\item{filter}{\verb{named list()} Specify to load only desired features,
e.g., \code{list(type = c("gene", "mRNA"), seqid = "chr10")}.}

\item{nrows}{\code{-1} or the maximum number of rows to read in (after
filtering).}

\item{raw_data}{\code{logical(1)} If TRUE, numeric columns (e.g. "start" or
"score") are loaded as character vectors and as-is i.e. how they are found
in the file.}
}
\value{
A \code{DataFrame} with columns corresponding to those in the GFF.
}
\description{
Reads a file in GFF format and creates a data frame or
\code{\link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame()}} object from it. This is a lower-level function
that should not be called by the end user. Users are recommended to use
the \code{import()} function on the \code{GFFFile} or file path.
}
\examples{

## Standard GFF columns.
GFFcolnames()
GFFcolnames(GFF1=TRUE)  # "group" instead of "attributes"

test_gff3 <- system.file(
    "extdata", "genes.gff3", package="Bioc.gff", mustWork=TRUE
)

## Load everything.
df0 <- readGFF(test_gff3)
head(df0)

## Load some tags only (in addition to the standard GFF columns).
my_tags <- c("ID", "Parent", "Name", "Dbxref", "geneID")
df1 <- readGFF(test_gff3, tags=my_tags)
head(df1)

## Load no tags (in that case, the "attributes" standard column
## is loaded).
df2 <- readGFF(test_gff3, tags=character(0))
head(df2)

## Load some standard GFF columns only (in addition to all tags).
my_columns <- c("seqid", "start", "end", "strand", "type")
df3 <- readGFF(test_gff3, columns=my_columns)
df3
table(df3$seqid, df3$type)

library(GenomicRanges)
makeGRangesFromDataFrame(df3, keep.extra.columns=TRUE)

## Combine use of 'columns' and 'tags' arguments.
readGFF(test_gff3, columns=my_columns, tags=c("ID", "Parent", "Name"))
readGFF(test_gff3, columns=my_columns, tags=character(0))

## Use the 'filter' argument to load only features of type "gene"
## or "mRNA" located on chr10.
my_filter <- list(type=c("gene", "mRNA"), seqid="chr10")
readGFF(test_gff3, filter=my_filter)
readGFF(test_gff3, columns=my_columns, tags=character(0), filter=my_filter)

}
\seealso{
\itemize{
\item \link[=GFFFile-class]{import} for importing a GFF file as a
\code{\link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges()}} object.
\item \code{\link[GenomicRanges:makeGRangesFromDataFrame]{GenomicRanges::makeGRangesFromDataFrame()}} in the
\pkg{GenomicRanges} package for making a \code{\link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges()}}
object from a \code{data.frame} or \code{\link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame()}} object.
\item \code{\link[txdbmaker:makeTxDbFromGFF]{txdbmaker::makeTxDbFromGFF()}} in the \pkg{txdbmaker}
package for importing a GFF file as a \link[GenomicFeatures:TxDb-class]{TxDb}
object.
\item The \code{\link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame()}} class in the \pkg{S4Vectors} package.
}
}
\author{
H. Pagès
}
\keyword{manip}
