% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadataFromNCBI.R
\name{metadataFromNCBI}
\alias{metadataFromNCBI}
\alias{isNCBISpeciesURL}
\alias{parseOrganismFromNCBI}
\alias{parseTaxonomyIDFromNCBI}
\title{Obtain metadata from NCBI}
\usage{
isNCBISpeciesURL(url)

metadataFromNCBI(url)

parseOrganismFromNCBI(html)

parseTaxonomyIDFromNCBI(html, url)
}
\arguments{
\item{url}{A URL to the NCBI Taxonomy Browser, typically obtained from a
GFF file with the \verb{## species} line.}
}
\value{
\itemize{
\item metadataFromNCBI: A \code{list} with two elements: \verb{Taxonomy ID} and
\code{Organism}.
\item parseOrganismFromNCBI: A \code{character} with the Organism name.
\item isNCBISpeciesURL: A \code{logical} indicating if the URL is from the NCBI
Taxonomy Browser.
\item parseTaxonomyIDFromNCBI: A \code{character} with the Taxonomy ID.
}
}
\description{
These helper functions obtain both the Taxonomy ID and the Organism name from
the NCBI Taxonomy Browser. They are a modern re-write of the old functions in
\code{rtracklayer}. They use \code{httr2} and \code{rvest} to parse the HTML content.
}
\examples{
\donttest{
  isNCBISpeciesURL(.NCBI_TAX_URL)

  metadataFromNCBI(
      paste0(.NCBI_TAX_URL, "?mode=Info&id=9606")
  )
  metadataFromNCBI(
      paste0(.NCBI_TAX_URL, "?id=3702")
  )
  metadataFromNCBI(
      paste0(.NCBI_TAX_URL, "?name=drosophila+melanogaster")
  )
  metadataFromNCBI(
      paste0(.NCBI_TAX_URL, "?name=drosophila+miranda")
  )
}
}
\keyword{internal}
