% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leadingEdge.R
\name{wmwLeadingEdge}
\alias{wmwLeadingEdge}
\title{Identify BioQC leading-edge genes of one gene-set}
\usage{
wmwLeadingEdge(
  matrix,
  indexVector,
  valType = c("p.greater", "p.less", "p.two.sided", "U", "abs.log10p.greater",
    "log10p.less", "abs.log10p.two.sided", "Q", "r", "f", "U1", "U2"),
  thr = 0.05,
  reference = c("background", "geneset")
)
}
\arguments{
\item{matrix}{A numeric matrix}

\item{indexVector}{An integer vector, giving indices of a gene-set of interest}

\item{valType}{Value type, consistent with the types in \code{wmwTest}}

\item{thr}{Threshold of the value, greater or less than which the gene-set is considered significantly enriched in one sample}

\item{reference}{Character string, which reference is used? If \code{background}, genes with expression higher than the median of the background are reported. Otherwise in the case of \code{geneset}, genes with expression higher than the median of the gene-set is reported. Default is \code{background}, which is consistent with the results of the Wilcoxon-Mann-Whitney tests.}
}
\value{
A list of integer vectors.

BioQC leading-edge genes are defined as those features whose expression is higher than the median expression of the background in a sample.  The function identifies leading-edge genes of a given dataset (specified by the index vector) in a number of samples (specified by the matrix, with genes/features in rows and samples in columns) in three steps. The function calls \code{wmwTest} to run BioQC and identify samples in which the gene-set is significantly enriched. The enrichment criteria is specified by \code{valType} and \code{thr}. Then the function identifies genes in the gene-set that have greater or less expresion than the median value of the \code{reference} in those samples showing significant enrichment. Finally, it reports either leading-edge genes in individual samples, or the intersection/union of leading-edge genes in multiple samples.
}
\description{
Identify BioQC leading-edge genes of one gene-set
}
\examples{
myProfile <- c(rnorm(5, 3), rnorm(15, -3), rnorm(100, 0))
myProfile2 <- c(rnorm(15, 3), rnorm(5, -3), rnorm(100, 0))
myProfile3 <- c(rnorm(10, 5), rnorm(10, 0), rnorm(100, 0))
myProfileMat <- cbind(myProfile, myProfile2, myProfile3)
wmwLeadingEdge(myProfileMat, 1:20, valType="p.greater")
wmwLeadingEdge(myProfileMat, 1:20, valType="log10p.less")
wmwLeadingEdge(myProfileMat, 1:20, valType="U", reference="geneset")
wmwLeadingEdge(myProfileMat, 1:20, valType="abs.log10p.greater")
}
\seealso{
\code{\link{wmwTest}}
}
