% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GmtList-funcs.R
\name{setNamespace}
\alias{setNamespace}
\title{Set the namespace field in each gene-set within a GmtList}
\usage{
setNamespace(x, namespace)
}
\arguments{
\item{x}{A \code{GmtList} object encoding a list of gene-sets}

\item{namespace}{It can be either a function that applies to a \code{gene-set list} element of the object (for instance \code{function(x) x$desc} to extract description), or a vector of the same length of \code{x}, or in the special case \code{NULL}, which will erase the field namespace.

Note that using vectors as \code{namespace} leads to poor performance when the input object has many gene-sets.}
}
\description{
Set the namespace field in each gene-set within a GmtList
}
\examples{
myGmtList <- GmtList(list(list(name="GeneSet1", desc="Namespace1", genes=LETTERS[1:3]),
  list(name="GeneSet2", desc="Namespace1", genes=rep(LETTERS[4:6],2)),
  list(name="GeneSet1", desc="Namespace1", genes=LETTERS[4:6]),
  list(name="GeneSet3", desc="Namespace2", genes=LETTERS[1:5])))
hasNamespace(myGmtList)
myGmtList2 <- setNamespace(myGmtList, namespace=function(x) x$desc)
gsNamespace(myGmtList2)
## the function can provide flexible ways to encode the gene-set namespace
myGmtList3 <- setNamespace(myGmtList, namespace=function(x) gsub("Namespace", "C", x$desc))
gsNamespace(myGmtList3)
## using vectors
myGmtList4 <- setNamespace(myGmtList, namespace=c("C1", "C1", "C1", "C2"))
gsNamespace(myGmtList4)
myGmtList2null <- setNamespace(myGmtList2, namespace=NULL)
hasNamespace(myGmtList2null)
}
