% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy.R
\name{sampleSpecialization}
\alias{sampleSpecialization}
\title{Entropy-based sample specialization}
\usage{
sampleSpecialization(mat, norm = TRUE)
}
\arguments{
\item{mat}{A matrix (usually an expression matrix), with genes (features) in rows and samples in columns.}

\item{norm}{Logical, whether the specialization should be normalized by \code{log2(ncol(mat))}.}
}
\value{
A vector as long as the column number of the input matrix
}
\description{
Entropy-based sample specialization
}
\examples{
myMat <- rbind(c(3,4,5),c(6,6,6), c(0,2,4))
sampleSpecialization(myMat)
sampleSpecialization(myMat, norm=TRUE)

myRandomMat <- matrix(runif(1000), ncol=20)
sampleSpecialization(myRandomMat)
sampleSpecialization(myRandomMat, norm=TRUE)
}
\references{
Martinez and Reyes-Valdes (2008) Defining diversity, 
specialization, and gene specificity in transcriptomes through information 
theory. PNAS 105(28):9709--9714
}
\seealso{
\code{\link{entropy}} and \code{\link{entropyDiversity}}
}
