% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocess.R
\name{remove_nonexp}
\alias{remove_nonexp}
\title{Remove genes that are not expressed based on a user-defined threshold}
\usage{
remove_nonexp(
  exp,
  method = "median",
  min_exp = 1,
  min_percentage_samples = 0.25
)
}
\arguments{
\item{exp}{A gene expression data frame with genes in row names
and samples in column names or a `SummarizedExperiment` object.}

\item{method}{Criterion to filter non-expressed genes out.
One of "mean", "median", "percentage", or "allsamples". Default is "median".}

\item{min_exp}{If method is 'mean', 'median', or 'allsamples',
the minimum value for a gene to be considered expressed.
If method is 'percentage', the minimum value each gene must have in
at least n percent of samples to be considered expressed.}

\item{min_percentage_samples}{In case the user chooses 'percentage' as method,
expressed genes must have expression >= min_exp in at least this percentage.
Values must range from 0 to 1.}
}
\value{
Filtered gene expression data frame or `SummarizedExperiment` object.
}
\description{
Remove genes that are not expressed based on a user-defined threshold
}
\examples{
data(zma.se)
filt_exp <- remove_nonexp(zma.se, min_exp = 5)
}
\seealso{
\code{\link[matrixStats]{rowMedians}}
 \code{\link[WGCNA]{goodSamplesGenes}}
}
\author{
Fabricio Almeida-Silva
}
