% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grn_inference.R
\name{grn_average_rank}
\alias{grn_average_rank}
\title{Rank edge weights for GRNs and calculate average across different methods}
\usage{
grn_average_rank(list_edges)
}
\arguments{
\item{list_edges}{List containing edge lists as returned by
the function \code{grn_combined}.}
}
\value{
Edge list containing regulator, target and mean rank from
all algorithms.
}
\description{
Rank edge weights for GRNs and calculate average across different methods
}
\examples{
data(filt.se)
tfs <- sample(rownames(filt.se), size=50, replace=FALSE)
grn_list <- grn_combined(filt.se, regulators=tfs, nTrees=2)
ranked_grn <- grn_average_rank(grn_list)
}
